/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.dto.WechatMenu;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.mapper.WechatMenuMapper;
import hls.support.core.wechat.service.IWechatMenuService;
import hls.support.core.wechat.utils.WeChatUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.bean.menu.WxMenu;
import me.chanjar.weixin.common.bean.menu.WxMenuButton;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.mp.api.WxMpService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.common.util.UrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class WechatMenuServiceImpl
extends BaseServiceImpl<WechatMenu>
implements IWechatMenuService {
    private String qyMenuApi = "https://qyapi.weixin.qq.com/cgi-bin/menu/create?access_token={ACCESS_TOKEN}&agentid={AGENTID}";
    private static Logger logger = LoggerFactory.getLogger(WechatMenuServiceImpl.class);
    @Autowired
    private WechatEnterpriseAppMapper appMapper;
    @Autowired
    private WechatAccountMapper accountMapper;
    @Autowired
    private WechatMenuMapper menuMapper;
    @Value(value="#{configProperties['http.proxy.port']}")
    private Integer proxyPort;
    @Value(value="#{configProperties['http.proxy.host']}")
    private String proxyHost;
    private static final String urlPrefix = "https://open.weixin.qq.com/connect/oauth2/authorize?";
    private static final String responseType = "code";
    private static final String urlSuffix = "#wechat_redirect";
    private static final String encodeTypeUtf8 = "utf-8";
    private static final String buttonTypeView = "view";

    private boolean validateData(WechatMenu dto) {
        Long wechatAccountId = dto.getWechatAccountId();
        if (wechatAccountId == null) {
            logger.error("app id is null");
            return false;
        }
        WechatEnterpriseApp app = (WechatEnterpriseApp)this.appMapper.selectByPrimaryKey(wechatAccountId);
        if (app == null) {
            logger.error("target app not found.");
            return false;
        }
        WechatAccount account = (WechatAccount)this.accountMapper.selectByPrimaryKey(app.getAccountId());
        if (account == null) {
            logger.error("target account not found.");
            return false;
        }
        return true;
    }

    private Map<String, Object> getCorpMenus(Long accountId) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        LinkedList<Map<String, Object>> buttons = new LinkedList<Map<String, Object>>();
        map.put("buttons", buttons);
        List<WechatMenu> menus = this.menuMapper.selectMenusByAccountId(accountId);
        if (menus == null || menus.size() < 1) {
            return map;
        }
        LinkedList<WechatMenu> mains = new LinkedList<WechatMenu>();
        HashMap subs = new HashMap(menus.size());
        for (WechatMenu menu : menus) {
            Long parentMenuId = menu.getParentMenuId();
            if (parentMenuId != null) {
                List<Map<String, Object>> list = subs.containsKey(parentMenuId) ? (List)subs.get(parentMenuId) : new LinkedList();
                list.add(this.parse2Map(menu, false));
                subs.put(parentMenuId, list);
                continue;
            }
            mains.add(menu);
        }
        if (mains.size() < 1) {
            return map;
        }
        for (WechatMenu main : mains) {
            Map<String, Object> menu;
            if (subs.containsKey(main.getId())) {
                menu = this.parse2Map(main, true);
                menu.put("sub_button", subs.get(main.getId()));
                buttons.add(menu);
                continue;
            }
            menu = this.parse2Map(main, false);
            buttons.add(menu);
        }
        return map;
    }

    private Map<String, Object> parse2Map(WechatMenu menu, boolean hasChild) {
        if (menu == null) {
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("name", menu.getName());
        if (!hasChild) {
            map.put("type", menu.getType());
            if (buttonTypeView.equalsIgnoreCase(menu.getType())) {
                map.put("url", menu.getUrl());
            } else {
                map.put("key", menu.getMenuKey());
            }
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResponseData addMenu(IRequest requestCtx, WechatMenu dto) {
        ResponseData responseData = new ResponseData(false);
        if (!this.validateData(dto)) {
            responseData.setMessage("request data validate error.");
            return responseData;
        }
        dto.setIsPublished("N");
        try {
            List<WechatMenu> childMenus;
            this.menuMapper.insertSelective(dto);
            Long parentMenuId = dto.getId();
            if (parentMenuId != null && (childMenus = dto.getChildMenus()) != null) {
                for (WechatMenu child : childMenus) {
                    child.setParentMenuId(parentMenuId);
                    child.setWechatAccountId(dto.getWechatAccountId());
                    child.setIsPublished("N");
                    this.menuMapper.insertSelective(child);
                }
            }
        }
        catch (Exception e) {
            logger.error("insert menu data failed,", (Throwable)e);
            responseData.setMessage("insert menu data failed.");
            return new ResponseData(false);
        }
        responseData.setSuccess(true);
        return responseData;
    }

    @Override
    public ResponseData updateMenu(IRequest requestCtx, List<WechatMenu> wechatMenus) {
        ResponseData responseData = new ResponseData(false);
        if (CollectionUtils.isNotEmpty(wechatMenus)) {
            for (WechatMenu dto : wechatMenus) {
                if (this.validateData(dto)) {
                    if ((dto = this.setUrl(dto)) == null) {
                        responseData.setMessage("set url for menu error");
                        return responseData;
                    }
                    dto.setIsPublished("N");
                    List<WechatMenu> childMenus = dto.getChildMenus();
                    if (dto.getId() != null) {
                        this.menuMapper.updateByPrimaryKeySelective(dto);
                    } else {
                        this.menuMapper.insertSelective(dto);
                    }
                    WechatMenu menu = new WechatMenu();
                    menu.setParentMenuId(dto.getId());
                    this.menuMapper.delete(menu);
                    if (childMenus == null) continue;
                    for (WechatMenu child : childMenus) {
                        child.setWechatAccountId(dto.getWechatAccountId());
                        child = this.setUrl(child);
                        if (child == null) {
                            responseData.setMessage("set url for menu error.");
                            return responseData;
                        }
                        child.setParentMenuId(dto.getId());
                        child.setWechatAccountId(dto.getWechatAccountId());
                        child.setIsPublished("N");
                        this.menuMapper.insertSelective(child);
                    }
                    continue;
                }
                responseData.setMessage("request data validate error.");
                return responseData;
            }
        }
        responseData.setSuccess(true);
        return responseData;
    }

    @Override
    public ResponseData deleteMenu(IRequest requestCtx, WechatMenu dto) {
        ResponseData responseData = new ResponseData(false);
        WechatMenu parent = (WechatMenu)this.menuMapper.selectByPrimaryKey(dto);
        if (parent == null) {
            responseData.setMessage("target menu not found.");
            return responseData;
        }
        WechatMenu menu = new WechatMenu();
        menu.setParentMenuId(parent.getId());
        try {
            this.menuMapper.delete(menu);
            this.menuMapper.deleteByPrimaryKey(parent);
        }
        catch (Exception e) {
            logger.error("delete menus failed,", (Throwable)e);
            responseData.setMessage("delete menus failed," + e);
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    @Override
    public ResponseData queryMenu(IRequest requestCtx, WechatMenu dto) {
        ResponseData responseData = new ResponseData(false);
        if (this.validateData(dto)) {
            List<WechatMenu> menus = this.menuMapper.select(dto);
            ArrayList<WechatMenu> parents = new ArrayList<WechatMenu>();
            ArrayList<WechatMenu> children = new ArrayList<WechatMenu>();
            for (WechatMenu menu : menus) {
                if (menu.getParentMenuId() == null) {
                    parents.add(menu);
                    continue;
                }
                children.add(menu);
            }
            for (WechatMenu parent : parents) {
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    WechatMenu child = (WechatMenu)iterator.next();
                    if (!child.getParentMenuId().equals(parent.getId())) continue;
                    List<WechatMenu> childMenus = parent.getChildMenus();
                    if (childMenus == null) {
                        childMenus = new ArrayList<WechatMenu>();
                    }
                    childMenus.add(child);
                    parent.setChildMenus(childMenus);
                    iterator.remove();
                }
            }
            responseData.setSuccess(true);
            responseData.setRows(parents);
            return responseData;
        }
        responseData.setMessage("request data validate error.");
        return responseData;
    }

    @Override
    public ResponseData synchronizeMenu(IRequest requestCtx, WechatMenu dto) {
        ResponseData responseData = new ResponseData(false);
        Long wechatAccountId = dto.getWechatAccountId();
        if (wechatAccountId == null) {
            responseData.setMessage("app id is null");
            return responseData;
        }
        WechatEnterpriseApp app = (WechatEnterpriseApp)this.appMapper.selectByPrimaryKey(wechatAccountId);
        if (app == null) {
            responseData.setMessage("target app not found.");
            return responseData;
        }
        WechatAccount account = (WechatAccount)this.accountMapper.selectByPrimaryKey(app.getAccountId());
        if (account == null) {
            responseData.setMessage("target account not found.");
            return responseData;
        }
        Integer accountType = account.getAccountType();
        List buttons = null;
        if (accountType.equals(WechatAccount.CORP)) {
            WxCpService wxCpService = WeChatUtils.initWxCpService(account.getAppId(), app.getSecret(), Integer.valueOf(app.getAgentId()), this.proxyHost, this.proxyPort);
            try {
                WxMenu wxMenu = wxCpService.getMenuService().get();
                buttons = wxMenu.getButtons();
            }
            catch (WxErrorException e) {
                logger.error("get menus data from wechat server failed.", (Throwable)e);
                responseData.setMessage("get menus data from wechat server failed." + e.getMessage());
                return responseData;
            }
        }
        if (accountType.equals(WechatAccount.SERV) || accountType.equals(WechatAccount.SUBS)) {
            WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
            try {
                buttons = wxMpService.getMenuService().menuGet().getMenu().getButtons();
            }
            catch (WxErrorException e) {
                logger.error("get menus data from wechat server failed.", (Throwable)e);
                responseData.setMessage("get menus data from wechat server failed." + e.getMessage());
                return responseData;
            }
        }
        WechatMenu menu = new WechatMenu();
        menu.setWechatAccountId(app.getId());
        try {
            this.menuMapper.delete(menu);
            if (CollectionUtils.isNotEmpty((Collection)buttons)) {
                for (WxMenuButton button : buttons) {
                    Map<String, String> map = this.resolveUrl(button.getUrl());
                    WechatMenu parent = new WechatMenu();
                    BeanUtils.copyProperties((Object)button, (Object)parent);
                    parent.setWechatAccountId(app.getId());
                    parent.setMenuKey(button.getKey());
                    if (map != null) {
                        parent.setIsPublished("Y");
                        parent.setRedirectUri(map.get("redirect_uri"));
                        parent.setScope(map.get("scope"));
                        parent.setState(Integer.valueOf(StringUtils.split((String)map.get("state"), (String)"#")[0]));
                    }
                    this.menuMapper.insertSelective(parent);
                    List subButtons = button.getSubButtons();
                    if (!CollectionUtils.isNotEmpty((Collection)subButtons)) continue;
                    for (WxMenuButton subButton : subButtons) {
                        Map<String, String> childMap = this.resolveUrl(subButton.getUrl());
                        if (childMap == null) continue;
                        WechatMenu child = new WechatMenu();
                        BeanUtils.copyProperties((Object)subButton, (Object)child);
                        child.setWechatAccountId(app.getId());
                        child.setMenuKey(subButton.getKey());
                        child.setParentMenuId(parent.getId());
                        child.setIsPublished("Y");
                        child.setState(Integer.valueOf(StringUtils.split((String)childMap.get("state"), (String)"#")[0]));
                        child.setScope(childMap.get("scope"));
                        child.setRedirectUri(childMap.get("redirect_uri"));
                        this.menuMapper.insertSelective(child);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("refresh menu data in database failed,", (Throwable)e);
            responseData.setMessage("refresh menu data in database failed.");
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    @Override
    public ResponseData publishMenu(IRequest requestCtx, WechatMenu dto) {
        ResponseData responseData = new ResponseData(false);
        Long wechatAccountId = dto.getWechatAccountId();
        if (wechatAccountId == null) {
            responseData.setMessage("app id is null");
            return responseData;
        }
        WechatEnterpriseApp app = (WechatEnterpriseApp)this.appMapper.selectByPrimaryKey(wechatAccountId);
        if (app == null) {
            responseData.setMessage("target app not found.");
            return responseData;
        }
        WechatAccount account = (WechatAccount)this.accountMapper.selectByPrimaryKey(app.getAccountId());
        if (account == null) {
            responseData.setMessage("target account not found.");
            return responseData;
        }
        Integer accountType = account.getAccountType();
        WechatMenu menu = new WechatMenu();
        menu.setWechatAccountId(app.getId());
        List<WechatMenu> menus = this.menuMapper.select(menu);
        ArrayList<WechatMenu> parents = new ArrayList<WechatMenu>();
        ArrayList<WechatMenu> children = new ArrayList<WechatMenu>();
        for (WechatMenu m : menus) {
            m.setIsPublished("Y");
            this.menuMapper.updateByPrimaryKeySelective(m);
            if (m.getParentMenuId() == null) {
                parents.add(m);
                continue;
            }
            children.add(m);
        }
        WxMenu wxMenu = new WxMenu();
        ArrayList<WxMenuButton> buttons = new ArrayList<WxMenuButton>();
        for (WechatMenu parent : parents) {
            WxMenuButton button = new WxMenuButton();
            BeanUtils.copyProperties((Object)parent, (Object)button);
            button.setType(buttonTypeView);
            button.setKey(parent.getMenuKey());
            if (accountType.equals(WechatAccount.SERV) || accountType.equals(WechatAccount.SUBS)) {
                button.setAppId(account.getAppId());
            }
            ArrayList<WxMenuButton> subButtons = new ArrayList<WxMenuButton>();
            for (WechatMenu child : children) {
                if (!child.getParentMenuId().equals(parent.getId())) continue;
                WxMenuButton subButton = new WxMenuButton();
                BeanUtils.copyProperties((Object)child, (Object)subButton);
                subButton.setKey(child.getMenuKey());
                subButton.setType(buttonTypeView);
                if (accountType.equals(WechatAccount.SERV) || accountType.equals(WechatAccount.SUBS)) {
                    subButton.setAppId(account.getAppId());
                }
                subButtons.add(subButton);
            }
            button.setSubButtons(subButtons);
            buttons.add(button);
        }
        wxMenu.setButtons(buttons);
        if (accountType.equals(WechatAccount.CORP)) {
            WxCpService wxCpService = WeChatUtils.initWxCpService(account.getAppId(), app.getSecret(), Integer.valueOf(app.getAgentId()), this.proxyHost, this.proxyPort);
            try {
                wxCpService.getMenuService().create(wxMenu);
            }
            catch (WxErrorException e) {
                logger.error("create menu failed,", (Throwable)e);
                responseData.setMessage("create menu failed.");
                return responseData;
            }
        } else if (accountType.equals(WechatAccount.SERV) || accountType.equals(WechatAccount.SUBS)) {
            WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), null, null);
            try {
                wxMpService.getMenuService().menuCreate(wxMenu);
            }
            catch (WxErrorException e) {
                logger.error("create menu failed,", (Throwable)e);
                responseData.setMessage("create menu failed.");
                return responseData;
            }
        } else {
            responseData.setMessage("invalid account type.");
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }

    @Override
    public ResponseData pushMenus(Long accountId) {
        return null;
    }

    private WechatMenu setUrl(WechatMenu dto) {
        Long wechatAccountId = dto.getWechatAccountId();
        if (wechatAccountId == null) {
            logger.error("wechat menu's wechatAccountId can not be null.");
            return null;
        }
        String url = this.generateUrl(wechatAccountId, dto.getRedirectUri(), dto.getScope(), dto.getState());
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            dto.setUrl(url);
        }
        return dto;
    }

    private String generateUrl(Long wecchatAccountId, String redirectUri, String scope, Integer state) {
        String encodeUri;
        if (StringUtils.isEmpty((CharSequence)redirectUri) || StringUtils.isEmpty((CharSequence)scope) || state == null) {
            return null;
        }
        WechatEnterpriseApp app = (WechatEnterpriseApp)this.appMapper.selectByPrimaryKey(wecchatAccountId);
        if (app == null) {
            logger.error("app not found.");
            return null;
        }
        WechatAccount account = (WechatAccount)this.accountMapper.selectByPrimaryKey(app.getAccountId());
        if (account == null) {
            logger.error("account not found.");
            return null;
        }
        try {
            encodeUri = URLEncoder.encode(redirectUri, encodeTypeUtf8);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("encode redirectUri failed,", (Throwable)e);
            return null;
        }
        return "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + account.getAppId() + "&redirect_uri=" + encodeUri + "&response_type=" + responseType + "&scope=" + scope + "&state=" + state + urlSuffix;
    }

    private Map<String, String> resolveUrl(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        try {
            url = URLDecoder.decode(url, encodeTypeUtf8);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("url decode error", (Throwable)e);
        }
        return UrlUtils.parseQueryString((String)url);
    }
}

