/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.wechat.dto.MemberAdditionalInfo;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatMember;
import hls.support.core.wechat.dto.WechatMemberTag;
import hls.support.core.wechat.dto.WechatTag;
import hls.support.core.wechat.formbean.UserTag;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatMemberAdditionalInfoMapper;
import hls.support.core.wechat.mapper.WechatMemberMapper;
import hls.support.core.wechat.mapper.WechatMemberTagMapper;
import hls.support.core.wechat.mapper.WechatTagMapper;
import hls.support.core.wechat.service.IWechatMemberService;
import java.util.List;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.cp.api.impl.WxCpServiceImpl;
import me.chanjar.weixin.cp.bean.WxCpUser;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.config.WxCpInMemoryConfigStorage;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.WxMpInMemoryConfigStorage;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class WechatMemberServiceImpl
extends BaseServiceImpl<WechatMember>
implements IWechatMemberService {
    private static Logger logger = LoggerFactory.getLogger(WechatMemberServiceImpl.class);
    @Autowired
    private WechatMemberMapper wechatMemberMapper;
    @Autowired
    private WechatAccountMapper wechatAccountMapper;
    @Autowired
    private WechatMemberAdditionalInfoMapper wechatMemberAdditionalInfoMapper;
    @Autowired
    private WechatTagMapper wechatTagMapper;
    @Autowired
    private WechatMemberTagMapper wechatMemberTagMapper;

    @Override
    public List<WechatMember> queryMemberByDepart(IRequest iRequest, WechatMember wechatMember, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        return this.wechatMemberMapper.queryMemberByDepart(wechatMember);
    }

    @Override
    public List<WechatMember> queryMemberByTag(IRequest iRequest, WechatMember wechatMember, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        return this.wechatMemberMapper.queryMemberByTag(wechatMember);
    }

    @Override
    public List<WechatMember> queryMemberDetail(IRequest requestContext, WechatMember wechatMember, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        return this.wechatMemberMapper.queryMemberDetail(wechatMember);
    }

    @Override
    public boolean batchUpdateMember(IRequest requestCtx, List<WechatMember> dto) {
        block10: for (WechatMember member : dto) {
            switch (member.get__status()) {
                case "add": {
                    if (((IWechatMemberService)this.self()).addMember(requestCtx, member)) continue block10;
                    return false;
                }
                case "update": {
                    if (((IWechatMemberService)this.self()).updateMember(requestCtx, member)) continue block10;
                    return false;
                }
                case "delete": {
                    if (((IWechatMemberService)this.self()).deleteMember(requestCtx, member)) continue block10;
                    return false;
                }
            }
            logger.warn("__status is not set properly when batch update wechat member.");
        }
        return true;
    }

    @Override
    public boolean addMember(IRequest requestCtx, WechatMember member) {
        if (member.getAccountId() == null) {
            logger.error("accountId is null when add a wechat tag!");
            return false;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(member.getAccountId());
        if (account == null) {
            logger.error("target wechat account can not be found!");
            return false;
        }
        Integer accountType = account.getAccountType();
        String appid = account.getAppId();
        String secret = account.getSecret();
        if (accountType == 1) {
            WxCpServiceImpl wxCpService = new WxCpServiceImpl();
            WxCpInMemoryConfigStorage config = new WxCpInMemoryConfigStorage();
            config.setCorpSecret(secret);
            config.setCorpId(appid);
            wxCpService.setWxCpConfigStorage((WxCpConfigStorage)config);
            WxCpUser user = new WxCpUser();
            user.setUserId(member.getUserId());
            user.setName(member.getName());
            String[] departmentIds = member.getDepartIds().split(",");
            Integer idsLength = departmentIds.length;
            if (departmentIds[idsLength - 1].equals("")) {
                idsLength = idsLength - 1;
            }
            Integer[] intIds = new Integer[idsLength.intValue()];
            for (int i = 0; i < idsLength; ++i) {
                intIds[i] = Integer.valueOf(departmentIds[i]);
            }
            user.setDepartIds(intIds);
            user.setEmail(member.getEmail());
            user.setMobile(member.getMobile());
            user.setPosition(member.getPosition());
            user.setTelephone(member.getTelephone());
            user.setEnglishName(member.getEnglishName());
            user.setEnable(member.getEnable());
            user.setAvatar(member.getAvatar());
            user.setHideMobile(member.getHideMobile());
            user.setStatus(member.getStatus());
            user.setIsLeader(member.getIsleader());
            switch (member.getGender()) {
                case "1": {
                    user.setGender(WxCpUser.Gender.MALE);
                    break;
                }
                case "2": {
                    user.setGender(WxCpUser.Gender.FEMAIL);
                    break;
                }
                default: {
                    logger.warn("user's gender code is incorrect");
                }
            }
            try {
                wxCpService.getUserService().create(user);
            }
            catch (WxErrorException e) {
                logger.error("create qiye user failed: ", (Throwable)e);
                return false;
            }
            this.wechatMemberMapper.insertSelective(member);
            MemberAdditionalInfo memberAdditionalInfo = new MemberAdditionalInfo();
            memberAdditionalInfo.setIsleader(member.getIsleader());
            memberAdditionalInfo.setHideMobile(member.getHideMobile());
            memberAdditionalInfo.setMobile(member.getMobile());
            memberAdditionalInfo.setPosition(member.getPosition());
            memberAdditionalInfo.setTelephone(member.getTelephone());
            memberAdditionalInfo.setEnglishName(member.getEnglishName());
            memberAdditionalInfo.setMemberId(member.getMemberId());
            this.wechatMemberAdditionalInfoMapper.insertSelective(memberAdditionalInfo);
            return true;
        }
        logger.error("invalid account type.");
        return false;
    }

    @Override
    public boolean updateMember(IRequest requestCtx, WechatMember member) {
        if (member.getAccountId() == null) {
            logger.error("accountId is null when add a wechat tag!");
            return false;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(member.getAccountId());
        if (account == null) {
            logger.error("target wechat account can not be found!");
            return false;
        }
        Integer accountType = account.getAccountType();
        String appid = account.getAppId();
        String secret = account.getSecret();
        if (accountType == 1) {
            WxCpServiceImpl wxCpService = new WxCpServiceImpl();
            WxCpInMemoryConfigStorage config = new WxCpInMemoryConfigStorage();
            config.setCorpSecret(secret);
            config.setCorpId(appid);
            wxCpService.setWxCpConfigStorage((WxCpConfigStorage)config);
            WxCpUser user = new WxCpUser();
            user.setUserId(member.getUserId());
            user.setName(member.getName());
            String[] departmentIds = member.getDepartIds().split(",");
            Integer idsLength = departmentIds.length;
            if (departmentIds[idsLength - 1].equals("")) {
                idsLength = idsLength - 1;
            }
            Integer[] intIds = new Integer[idsLength.intValue()];
            for (int i = 0; i < idsLength; ++i) {
                intIds[i] = Integer.valueOf(departmentIds[i]);
            }
            user.setDepartIds(intIds);
            BeanUtils.copyProperties((Object)member, (Object)user);
            switch (member.getGender()) {
                case "1": {
                    user.setGender(WxCpUser.Gender.MALE);
                    break;
                }
                case "2": {
                    user.setGender(WxCpUser.Gender.FEMAIL);
                    break;
                }
                default: {
                    logger.warn("user's gender code is incorrect.");
                }
            }
            try {
                wxCpService.getUserService().update(user);
            }
            catch (WxErrorException e) {
                logger.error("update qiye user failed: ", (Throwable)e);
                return false;
            }
            this.wechatMemberMapper.updateByPrimaryKeySelective(member);
            MemberAdditionalInfo memberAdditionalInfo = new MemberAdditionalInfo();
            BeanUtils.copyProperties((Object)member, (Object)memberAdditionalInfo);
            memberAdditionalInfo.setId(member.getAdditionalInfoId());
            this.wechatMemberAdditionalInfoMapper.updateByPrimaryKeySelective(memberAdditionalInfo);
        } else if (accountType == 2 || accountType == 3) {
            WxMpServiceImpl wxMpService = new WxMpServiceImpl();
            WxMpInMemoryConfigStorage config = new WxMpInMemoryConfigStorage();
            config.setSecret(secret);
            config.setAppId(appid);
            wxMpService.setWxMpConfigStorage((WxMpConfigStorage)config);
            try {
                wxMpService.getUserService().userUpdateRemark(member.getOpenId(), member.getRemark());
            }
            catch (WxErrorException e) {
                logger.error("update user remark failed:", (Throwable)e);
                return false;
            }
            MemberAdditionalInfo memberAdditionalInfo = new MemberAdditionalInfo();
            memberAdditionalInfo.setRemark(member.getRemark());
            memberAdditionalInfo.setId(member.getAdditionalInfoId());
            this.wechatMemberAdditionalInfoMapper.updateByPrimaryKeySelective(memberAdditionalInfo);
        } else {
            logger.error("invalid account type.");
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteMember(IRequest requestCtx, WechatMember member) {
        if (member.getAccountId() == null) {
            logger.error("accountId is null when add a wechat tag!");
            return false;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(member.getAccountId());
        if (account == null) {
            logger.error("target wechat account can not be found!");
            return false;
        }
        Integer accountType = account.getAccountType();
        String appid = account.getAppId();
        String secret = account.getSecret();
        if (accountType == 1) {
            WxCpServiceImpl wxCpService = new WxCpServiceImpl();
            WxCpInMemoryConfigStorage config = new WxCpInMemoryConfigStorage();
            config.setCorpSecret(secret);
            config.setCorpId(appid);
            wxCpService.setWxCpConfigStorage((WxCpConfigStorage)config);
            try {
                wxCpService.getUserService().delete(new String[]{member.getUserId()});
            }
            catch (WxErrorException e) {
                logger.error("delete qiye user failed:", (Throwable)e);
                return false;
            }
        } else {
            logger.error("invalid account type.");
            return false;
        }
        this.wechatMemberMapper.deleteByPrimaryKey(member);
        MemberAdditionalInfo additionalInfo = new MemberAdditionalInfo();
        additionalInfo.setId(member.getAdditionalInfoId());
        this.wechatMemberAdditionalInfoMapper.deleteByPrimaryKey(additionalInfo);
        return true;
    }

    @Override
    public ResponseData batchUpdateUserTag(IRequest requestCtx, UserTag userTag) {
        ResponseData responseData;
        block20: {
            block19: {
                Integer idsLength;
                responseData = new ResponseData(false);
                WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(userTag.getAccountId());
                if (account == null) {
                    logger.error("target account can not be found");
                    responseData.setMessage("target account can not be found");
                    return responseData;
                }
                int accountType = account.getAccountType();
                if (accountType != 2 && accountType != 3) break block19;
                String secret = account.getSecret();
                String appid = account.getAppId();
                WechatTag tag = (WechatTag)this.wechatTagMapper.selectByPrimaryKey(userTag.getTagId());
                if (!tag.getAccountId().equals(userTag.getAccountId())) {
                    logger.error("tag not belong to the account");
                    responseData.setMessage("tag not belong to the account");
                    return responseData;
                }
                String[] memberIds = userTag.getMemberIds().split(",");
                if (memberIds[(idsLength = Integer.valueOf(memberIds.length)) - 1].equals("")) {
                    idsLength = idsLength - 1;
                }
                String[] openIds = new String[idsLength.intValue()];
                for (int i = 0; i < idsLength; ++i) {
                    Long id = Long.valueOf(memberIds[i]);
                    WechatMember member = (WechatMember)this.wechatMemberMapper.selectByPrimaryKey(id);
                    if (!member.getAccountId().equals(userTag.getAccountId())) {
                        logger.error("user not belong to the account");
                        responseData.setMessage("user not belong to the account");
                        return responseData;
                    }
                    openIds[i] = member.getOpenId();
                }
                WxMpServiceImpl wxMpService = new WxMpServiceImpl();
                WxMpInMemoryConfigStorage config = new WxMpInMemoryConfigStorage();
                config.setSecret(secret);
                config.setAppId(appid);
                wxMpService.setWxMpConfigStorage((WxMpConfigStorage)config);
                switch (userTag.get__status()) {
                    case "add": {
                        try {
                            wxMpService.getUserTagService().batchTagging(Long.valueOf(Long.parseLong(tag.getTagId())), openIds);
                        }
                        catch (WxErrorException e) {
                            logger.error("__status not properly set when batch add user tag");
                            responseData.setMessage("__status not properly set when batch add user tag");
                            return responseData;
                        }
                        for (String memberId : memberIds) {
                            WechatMemberTag memberTag = new WechatMemberTag();
                            memberTag.setTagId(userTag.getTagId());
                            memberTag.setMemberId(Long.valueOf(memberId));
                            this.wechatMemberTagMapper.insertSelective(memberTag);
                        }
                        break block20;
                    }
                    case "delete": {
                        try {
                            wxMpService.getUserTagService().batchUntagging(Long.valueOf(Long.parseLong(tag.getTagId())), openIds);
                        }
                        catch (WxErrorException e) {
                            logger.error("__status not properly set when batch remove user tag");
                            responseData.setMessage("__status not properly set when batch remove user tag");
                            return responseData;
                        }
                        for (String memberId : memberIds) {
                            WechatMemberTag memberTag = new WechatMemberTag();
                            memberTag.setTagId(userTag.getTagId());
                            memberTag.setMemberId(Long.valueOf(memberId));
                            this.wechatMemberTagMapper.delete(memberTag);
                        }
                        break block20;
                    }
                    default: {
                        logger.error("invalid account type");
                        responseData.setMessage("invalid account type");
                        return responseData;
                    }
                }
            }
            logger.error("invalid account type");
            responseData.setMessage("invalid account type");
            return responseData;
        }
        responseData.setSuccess(true);
        return responseData;
    }
}

