/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatDepartment;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatDepartmentMapper;
import hls.support.core.wechat.service.IWechatDepartmentService;
import java.util.ArrayList;
import java.util.List;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.cp.api.impl.WxCpServiceImpl;
import me.chanjar.weixin.cp.bean.WxCpDepart;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.config.WxCpInMemoryConfigStorage;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class WechatDepartmentServiceImpl
extends BaseServiceImpl<WechatDepartment>
implements IWechatDepartmentService {
    private static Logger logger = LoggerFactory.getLogger(WechatDepartmentServiceImpl.class);
    @Autowired
    private WechatAccountMapper wechatAccountMapper;
    @Autowired
    private WechatDepartmentMapper wechatDepartmentMapper;

    @Override
    public ResponseData refresh(IRequest reusetContext, Long accountId) {
        List departList;
        ResponseData responseData = new ResponseData(false);
        if (accountId == null) {
            responseData.setMessage("invalid params");
            return responseData;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(accountId);
        if (account == null) {
            responseData.setMessage("could not found target wechat account");
            return responseData;
        }
        String corpId = account.getAppId();
        String secret = account.getSecret();
        WxCpInMemoryConfigStorage config = new WxCpInMemoryConfigStorage();
        config.setCorpId(corpId);
        config.setCorpSecret(secret);
        WxCpServiceImpl wxCpService = new WxCpServiceImpl();
        wxCpService.setWxCpConfigStorage((WxCpConfigStorage)config);
        try {
            departList = wxCpService.getDepartmentService().listAll();
        }
        catch (WxErrorException e) {
            logger.error("refresh departments data failed:", (Throwable)e);
            responseData.setMessage("refresh departments data failed.");
            return responseData;
        }
        WechatDepartment wechatDepartment = new WechatDepartment();
        WechatDepartment w = new WechatDepartment();
        w.setAccountId(accountId);
        List<WechatDepartment> wechatDepartments = this.wechatDepartmentMapper.queryDepartment(w);
        ArrayList<Integer> departmentIds = new ArrayList<Integer>();
        for (WxCpDepart depart : departList) {
            departmentIds.add(depart.getId());
        }
        for (WechatDepartment we : wechatDepartments) {
            if (departmentIds.indexOf(we.getDepartmentId()) != -1) continue;
            ((IWechatDepartmentService)this.self()).deleteByPrimaryKey(we);
        }
        for (WxCpDepart depart : departList) {
            wechatDepartment.setDepartmentId(depart.getId());
            wechatDepartment.setDepartmentName(depart.getName());
            wechatDepartment.setParentId(depart.getParentId());
            wechatDepartment.setDepartmentOrder(depart.getOrder());
            wechatDepartment.setAccountId(accountId);
            if (CollectionUtils.isNotEmpty(this.wechatDepartmentMapper.queryDepartment(wechatDepartment))) {
                wechatDepartment.setId(this.wechatDepartmentMapper.queryDepartment(wechatDepartment).get(0).getId());
                this.wechatDepartmentMapper.updateByPrimaryKeySelective(wechatDepartment);
            } else {
                this.wechatDepartmentMapper.insertSelective(wechatDepartment);
            }
            responseData.setSuccess(true);
        }
        return responseData;
    }

    @Override
    public List<WechatDepartment> queryDepartment(IRequest iRequest, WechatDepartment wechatDepartment, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        return this.wechatDepartmentMapper.queryDepartment(wechatDepartment);
    }

    @Override
    public List<WechatDepartment> treeListDeapartmentQuery(IRequest iRequest, WechatDepartment wechatDepartment) {
        return this.wechatDepartmentMapper.treeListDeapartmentQuery(wechatDepartment);
    }

    @Override
    public ResponseData addDepartment(IRequest iRequest, WechatDepartment wechatDepartment) {
        Integer departId;
        ResponseData responseData = new ResponseData(false);
        if (wechatDepartment.getAccountId() == null) {
            responseData.setMessage("invalid params");
            return responseData;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(wechatDepartment.getAccountId());
        if (account == null) {
            responseData.setMessage("target wechat account could not found");
            return responseData;
        }
        String corpId = account.getAppId();
        String secret = account.getSecret();
        WxCpInMemoryConfigStorage config = new WxCpInMemoryConfigStorage();
        config.setCorpId(corpId);
        config.setCorpSecret(secret);
        WxCpServiceImpl wxCpService = new WxCpServiceImpl();
        wxCpService.setWxCpConfigStorage((WxCpConfigStorage)config);
        WxCpDepart depart = new WxCpDepart();
        depart.setParentId(wechatDepartment.getParentId());
        depart.setOrder(wechatDepartment.getDepartmentOrder());
        depart.setName(wechatDepartment.getDepartmentName());
        try {
            departId = wxCpService.getDepartmentService().create(depart);
        }
        catch (WxErrorException e) {
            logger.error("create department failed\uff1a", (Throwable)e);
            responseData.setMessage("create department failed.");
            return responseData;
        }
        wechatDepartment.setDepartmentId(departId);
        this.wechatDepartmentMapper.insertSelective(wechatDepartment);
        return responseData;
    }

    @Override
    public ResponseData updateDepartment(IRequest iRequest, WechatDepartment wechatDepartment) {
        ResponseData responseData = new ResponseData(false);
        if (wechatDepartment.getAccountId() == null) {
            responseData.setMessage("invalid params");
            return responseData;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(wechatDepartment.getAccountId());
        if (account == null) {
            responseData.setMessage("target wechat account could not found");
            return responseData;
        }
        String corpId = account.getAppId();
        String secret = account.getSecret();
        WxCpInMemoryConfigStorage config = new WxCpInMemoryConfigStorage();
        config.setCorpId(corpId);
        config.setCorpSecret(secret);
        WxCpServiceImpl wxCpService = new WxCpServiceImpl();
        wxCpService.setWxCpConfigStorage((WxCpConfigStorage)config);
        WxCpDepart depart = new WxCpDepart();
        depart.setId(wechatDepartment.getDepartmentId());
        depart.setParentId(wechatDepartment.getParentId());
        depart.setOrder(wechatDepartment.getDepartmentOrder());
        depart.setName(wechatDepartment.getDepartmentName());
        try {
            wxCpService.getDepartmentService().update(depart);
        }
        catch (WxErrorException e) {
            logger.error("update department failed\uff1a", (Throwable)e);
            responseData.setMessage("update department failed.");
        }
        this.wechatDepartmentMapper.updateByPrimaryKeySelective(wechatDepartment);
        return responseData;
    }

    @Override
    public ResponseData deleteDepartment(IRequest iRequest, WechatDepartment wechatDepartment) {
        ResponseData responseData = new ResponseData(false);
        if (wechatDepartment.getAccountId() == null) {
            responseData.setMessage("invalid params");
            return responseData;
        }
        WechatAccount account = (WechatAccount)this.wechatAccountMapper.selectByPrimaryKey(wechatDepartment.getAccountId());
        if (account == null) {
            responseData.setMessage("could not found target wechat account");
            return responseData;
        }
        String corpId = account.getAppId();
        String secret = account.getSecret();
        WxCpInMemoryConfigStorage config = new WxCpInMemoryConfigStorage();
        config.setCorpId(corpId);
        config.setCorpSecret(secret);
        WxCpServiceImpl wxCpService = new WxCpServiceImpl();
        wxCpService.setWxCpConfigStorage((WxCpConfigStorage)config);
        try {
            wxCpService.getDepartmentService().delete(wechatDepartment.getDepartmentId());
        }
        catch (WxErrorException e) {
            logger.error("delete department failed\uff1a", (Throwable)e);
            responseData.setMessage("delete department failed.");
        }
        this.wechatDepartmentMapper.deleteByPrimaryKey(wechatDepartment);
        return responseData;
    }

    @Override
    public ResponseData batchUpdateDepartment(IRequest iRequest, List<WechatDepartment> wechatDepartments) {
        ResponseData responseData = new ResponseData(false);
        int count = 0;
        block10: for (WechatDepartment wechatDepartment : wechatDepartments) {
            switch (wechatDepartment.get__status()) {
                case "add": {
                    responseData = ((IWechatDepartmentService)this.self()).addDepartment(iRequest, wechatDepartment);
                    if (responseData.isSuccess()) continue block10;
                    ++count;
                    continue block10;
                }
                case "update": {
                    responseData = ((IWechatDepartmentService)this.self()).updateDepartment(iRequest, wechatDepartment);
                    if (responseData.isSuccess()) continue block10;
                    ++count;
                    continue block10;
                }
                case "delete": {
                    responseData = ((IWechatDepartmentService)this.self()).deleteDepartment(iRequest, wechatDepartment);
                    if (responseData.isSuccess()) continue block10;
                    ++count;
                    continue block10;
                }
            }
            logger.warn("_status is not set when batch update wechat department.");
        }
        if (count == 0) {
            responseData.setSuccess(true);
        }
        return responseData;
    }

    private void unitQueryDepartment(List<WechatDepartment> wechatDepartments, WechatDepartment wechatDepartment, List<Integer> departmentIds) {
        List<WechatDepartment> wechatDepartmentList = this.wechatDepartmentMapper.queryDepartment(wechatDepartment);
        if (wechatDepartmentList.size() > 0) {
            for (WechatDepartment wechatDepartment1 : wechatDepartmentList) {
                Integer parentid = wechatDepartment1.getDepartmentId();
                Long accountId = wechatDepartment1.getAccountId();
                WechatDepartment department = new WechatDepartment();
                department.setAccountId(accountId);
                department.setParentId(parentid);
                if (departmentIds.indexOf(parentid) != -1) continue;
                departmentIds.add(parentid);
                wechatDepartments.addAll(this.wechatDepartmentMapper.queryDepartment(department));
                this.unitQueryDepartment(wechatDepartments, department, departmentIds);
            }
        }
    }
}

