/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.hms.service.impl.PureNetUtilImpl;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.mybatis.entity.Example;
import com.hand.hap.mybatis.util.StringUtil;
import com.hand.hap.system.service.ISysConfigService;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.formbean.HavonInfo;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.service.IHavonMediaService;
import hls.support.core.wechat.utils.WeChatUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.mp.api.WxMpService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HavonMediaServiceImpl
implements IHavonMediaService {
    private static final String ERROR_ACCOUNT_NOT_FOUND = "ERROR_ACCOUNT_NOT_FOUND";
    private static final String ERROR_CONTRACT_CODE_EMPTY = "ERROR_CONTRACT_CODE_EMPTY";
    private static final String ERROR_ACCOUNT_NOT_SPECIFIED = "ERROR_ACCOUNT_NOT_SPECIFIED";
    public static final String STATUS_OK = "OK";
    private static final String ERROR_MEDIA_DOWNLOAD_FAILED = "ERROR_MEDIA_DOWNLOAD_FAILED";
    private static final String ERROR_ACCOUNT_TYPE = "ERROR_ACCOUNT_TYPE";
    private static final String ERROR_MEDIA_NOT_DOWNLOAD = "ERROR_MEDIA_NOT_DOWNLOAD";
    private static final String ERROR_MEDIA_NOT_UPLOAD = "ERROR_MEDIA_NOT_UPLOAD";
    private static final String ERROR_QUERY_TIME_EMPTY = "ERROR_QUERY_TIME_EMPTY";
    private static final String RESULT_ERROR = "-1";
    @Autowired
    private WechatEnterpriseAppMapper appMapper;
    @Autowired
    private WechatAccountMapper accountMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="#{configProperties['http.proxy.port']}")
    private Integer proxyPort;
    @Value(value="#{configProperties['http.proxy.host']}")
    private String proxyHost;
    private CloseableHttpClient httpClient;
    @Autowired
    IHapInterfaceHeaderService headerService;
    @Autowired
    ISysConfigService sysConfigService;

    public HavonMediaServiceImpl() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(15000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    @Override
    public JSONObject saveMedia2Business(HavonInfo havonInfo) {
        JSONObject json = new JSONObject();
        this.logger.debug("wechatCode:{}, mediaId:{},sysName:{},apiName:{}", new Object[]{havonInfo.getWechatCode(), havonInfo.getMediaId(), havonInfo.getSysName(), havonInfo.getApiName()});
        if (StringUtil.isNotEmpty(havonInfo.getWechatCode())) {
            Example example = new Example(WechatEnterpriseApp.class);
            Example.Criteria criteria = example.createCriteria();
            this.logger.debug("**********WechatCode:[" + havonInfo.getWechatCode() + "]**********");
            criteria.andEqualTo("wxCode", havonInfo.getWechatCode());
            List wechatEnterpriseApps = this.appMapper.selectByExample(example);
            if (CollectionUtils.isEmpty(wechatEnterpriseApps)) {
                json.put("false", (Object)ERROR_ACCOUNT_TYPE);
            } else if (wechatEnterpriseApps.size() > 1) {
                json.put("false", (Object)ERROR_ACCOUNT_TYPE);
            }
            WechatEnterpriseApp app = (WechatEnterpriseApp)wechatEnterpriseApps.get(0);
            WechatAccount account = (WechatAccount)this.accountMapper.selectByPrimaryKey(app.getAccountId());
            if (account == null) {
                json.put("false", (Object)ERROR_ACCOUNT_TYPE);
            }
            if (account.getAccountType().equals(WechatAccount.CORP)) {
                WxCpService wxCpService = WeChatUtils.initWxCpService(app.getCorpId(), app.getSecret(), Integer.valueOf(app.getAgentId()), this.proxyHost, this.proxyPort);
                try {
                    File download = wxCpService.getMediaService().download(havonInfo.getMediaId());
                    json = this.getHavon(download, havonInfo);
                    json.put("success", (Object)"true");
                }
                catch (WxErrorException e) {
                    json.put("false", (Object)ERROR_ACCOUNT_TYPE);
                }
            } else if (account.getAccountType().equals(WechatAccount.SERV) || account.getAccountType().equals(WechatAccount.SUBS)) {
                WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), this.proxyHost, this.proxyPort);
                try {
                    File download = wxMpService.getMaterialService().mediaDownload(havonInfo.getMediaId());
                    json = this.getHavon(download, havonInfo);
                }
                catch (WxErrorException e) {
                    json.put("false", (Object)ERROR_ACCOUNT_TYPE);
                }
            } else {
                json.put("false", (Object)ERROR_ACCOUNT_TYPE);
            }
        }
        return json;
    }

    private JSONObject getHavon(File file, HavonInfo info) {
        String apiName = info.getApiName();
        String sysName = info.getSysName();
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        this.logger.info("return hapInterfaceHeader:{}", (Object)hapInterfaceHeader);
        String iftUrl = hapInterfaceHeader.getIftUrl();
        String hanvonKey = this.sysConfigService.getConfigValue("HANVON.KEY");
        String newUrl = iftUrl.replace("YOURKEY", hanvonKey);
        if (hapInterfaceHeader == null) {
            this.logger.debug("headerAndLineDTO is null\uff0c apiName:{}, sysName:{}", (Object)apiName, (Object)sysName);
            return null;
        }
        JSONObject json = new JSONObject();
        String filePath = "";
        filePath = file.getPath();
        try {
            String imageStr = PureNetUtilImpl.GetBase64(filePath);
            String uid = InetAddress.getLocalHost().getHostAddress();
            String inboundParam = "";
            inboundParam = "{\"uid\":\"" + uid + "\" ,\"image\":\"" + imageStr + "\"}";
            String url = hapInterfaceHeader.getDomainUrl() + newUrl;
            json = this.post(inboundParam, url);
        }
        catch (Exception e) {
            this.logger.info(e.toString());
            json.put("error", (Object)e.getMessage());
        }
        return json;
    }

    public JSONObject post(String body, String https_url) {
        String resultData = "";
        String charset = "UTF-8";
        try {
            String line;
            URL myURL = new URL(https_url);
            HttpURLConnection connection = (HttpURLConnection)myURL.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            if (!body.isEmpty()) {
                connection.setDoOutput(true);
            }
            connection.setRequestProperty("Content-Type", "application/octet-stream");
            charset = "UTF-8";
            connection.connect();
            if (!body.isEmpty()) {
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(body.getBytes(charset));
                outputStream.flush();
                outputStream.close();
            }
            if (connection.getResponseCode() != 200) {
                throw new RuntimeException("HTTP GET Request Failed with Error code : " + connection.getResponseCode());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
            StringBuilder results = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                results.append(line);
            }
            reader.close();
            connection.disconnect();
            resultData = results.toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            this.logger.info("MalformedURLException", (Object)e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.info("IOException", (Object)e.getMessage());
        }
        resultData = resultData.toString().replaceAll("null", "\"\"");
        return JSONObject.parseObject((String)resultData);
    }
}

