/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.service.impl;

import com.hand.hap.core.IRequest;
import hls.support.core.responseMessage.service.IResponseMessageService;
import hls.support.core.wechat.components.DemoInterceptor;
import hls.support.core.wechat.components.MessageHandler;
import hls.support.core.wechat.components.MessageMatcher;
import hls.support.core.wechat.dto.AutoRecover;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.mapper.AutoRecoverMapper;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.service.IAcceptWechatService;
import hls.support.core.wechat.utils.WeChatUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpMessageInterceptor;
import me.chanjar.weixin.mp.api.WxMpMessageMatcher;
import me.chanjar.weixin.mp.api.WxMpMessageRouter;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.kefu.WxMpKefuMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.builder.kefu.NewsBuilder;
import me.chanjar.weixin.mp.builder.kefu.TextBuilder;
import me.chanjar.weixin.mp.builder.outxml.TransferCustomerServiceBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AcceptWechatServiceImpl
implements IAcceptWechatService {
    private static Logger logger = LoggerFactory.getLogger(AcceptWechatServiceImpl.class);
    @Autowired
    private WechatEnterpriseAppMapper appMapper;
    @Autowired
    private AutoRecoverMapper mapper;
    @Autowired
    private WechatAccountMapper accountMapper;
    @Autowired
    private IResponseMessageService responseMessageService;
    @Value(value="#{configProperties['http.proxy.port']}")
    private Integer proxyPort;
    @Value(value="#{configProperties['http.proxy.host']}")
    private String proxyHost;
    private String targetStr = "";
    private static int THE_FIRST_PICK = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filterSubscribe(HttpServletRequest request, HttpServletResponse response, IRequest iRequest) {
        WxMpService wxMpService;
        WechatAccount targetAccount;
        WechatEnterpriseApp targetApp;
        List<WechatEnterpriseApp> apps;
        WechatEnterpriseApp wea;
        WxMpXmlMessage inMessage;
        try {
            inMessage = WxMpXmlMessage.fromXml((InputStream)request.getInputStream());
        }
        catch (Throwable t) {
            logger.error("get xml message failed.", t);
            return;
        }
        PrintWriter out = null;
        try {
            out = response.getWriter();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String encrypt_type = request.getParameter("encrypt_type");
        logger.debug("********************************encrypt_type:" + encrypt_type + "************************************");
        String toUserName = inMessage.getToUser();
        String fromUserName = inMessage.getFromUser();
        String msgType = inMessage.getMsgType();
        String event = inMessage.getEvent();
        logger.debug("received message. toUserName is {}, fromUserName is {}, msgType is, event is {}", new Object[]{toUserName, fromUserName, msgType, event});
        if (msgType.equals("event") && event.equals("subscribe")) {
            wea = new WechatEnterpriseApp();
            wea.setWechatId(toUserName);
            apps = this.appMapper.select(wea);
            if (apps == null || apps.size() != 1) {
                logger.error("query data for wechatId error.");
                return;
            }
            targetApp = apps.get(0);
            String content = this.responseMessageService.messageContent(iRequest, targetApp.getId());
            if (StringUtils.isEmpty((CharSequence)content)) {
                logger.error("the result of query response content is null.");
                return;
            }
            WechatAccount targetAccount2 = (WechatAccount)this.accountMapper.selectByPrimaryKey(targetApp.getAccountId());
            if (targetAccount2 == null) {
                logger.error("query data for accountId error.");
                return;
            }
            WxMpService wxMpService2 = WeChatUtils.initWxMpService(targetAccount2.getAppId(), targetAccount2.getSecret(), this.proxyHost, this.proxyPort);
            WxMpKefuMessage m = ((TextBuilder)WxMpKefuMessage.TEXT().content(content).toUser(fromUserName)).build();
            try {
                wxMpService2.getKefuService().sendKefuMessage(m);
            }
            catch (WxErrorException e) {
                logger.error("send message custom failed.", (Throwable)e);
            }
        }
        if (encrypt_type != null && "aes".equals(encrypt_type)) {
            wea = new WechatEnterpriseApp();
            wea.setWechatId(toUserName);
            apps = this.appMapper.select(wea);
            targetApp = apps.get(0);
            targetAccount = (WechatAccount)this.accountMapper.selectByPrimaryKey(targetApp.getAccountId());
            try {
                wxMpService = WeChatUtils.initWxMpService(targetAccount.getAppId(), targetAccount.getSecret(), this.proxyHost, this.proxyPort);
                WxMpMessageRouter wxMpMessageRouter = new WxMpMessageRouter(wxMpService);
                wxMpMessageRouter.rule().matcher((WxMpMessageMatcher)new MessageMatcher()).interceptor((WxMpMessageInterceptor)new DemoInterceptor()).handler((WxMpMessageHandler)new MessageHandler()).end();
                WxMpXmlOutMessage xmlOutMsg = wxMpMessageRouter.route(inMessage);
                if (xmlOutMsg != null) {
                    out.print(xmlOutMsg.toXml());
                }
                List<AutoRecover> messages = this.mapper.queryAll();
                for (AutoRecover message : messages) {
                    if (!Pattern.matches(".*" + message.getContent() + ".*", inMessage.getContent())) continue;
                    this.targetStr = message.getContent();
                    break;
                }
                this.kf(fromUserName, wxMpService);
            }
            finally {
                out.close();
            }
        }
        wea = new WechatEnterpriseApp();
        wea.setWechatId(toUserName);
        apps = this.appMapper.select(wea);
        targetApp = apps.get(0);
        targetAccount = (WechatAccount)this.accountMapper.selectByPrimaryKey(targetApp.getAccountId());
        try {
            wxMpService = WeChatUtils.initWxMpService(targetAccount.getAppId(), targetAccount.getSecret(), this.proxyHost, this.proxyPort);
            out.print(((TransferCustomerServiceBuilder)((TransferCustomerServiceBuilder)WxMpXmlOutMessage.TRANSFER_CUSTOMER_SERVICE().fromUser(toUserName)).toUser(fromUserName)).build().toXml());
        }
        finally {
            out.close();
        }
    }

    public void kf(String fromUserName, WxMpService wxMpService) {
        wxMpService.getWxMpConfigStorage();
        AutoRecover autoRecover = new AutoRecover();
        autoRecover.setContent(this.targetStr);
        String reContent = this.mapper.selectSeq(autoRecover).get(THE_FIRST_PICK).getReContent();
        if (StringUtils.isEmpty((CharSequence)this.mapper.selectSeq(autoRecover).get(THE_FIRST_PICK).getPicUrl())) {
            WxMpKefuMessage m = ((TextBuilder)WxMpKefuMessage.TEXT().content(reContent).toUser(fromUserName)).build();
            try {
                wxMpService.getKefuService().sendKefuMessage(m);
            }
            catch (WxErrorException e) {
                logger.error("send message custom failed.", (Throwable)e);
            }
        } else {
            WxMpKefuMessage.WxArticle article = new WxMpKefuMessage.WxArticle();
            article.setUrl("URL");
            article.setPicUrl(this.mapper.selectSeq(autoRecover).get(THE_FIRST_PICK).getPicUrl());
            article.setDescription(this.mapper.selectSeq(autoRecover).get(THE_FIRST_PICK).getDescription());
            article.setTitle(this.mapper.selectSeq(autoRecover).get(THE_FIRST_PICK).getTitle());
            WxMpKefuMessage m = ((NewsBuilder)WxMpKefuMessage.NEWS().addArticle(new WxMpKefuMessage.WxArticle[]{article}).toUser(fromUserName)).build();
            try {
                wxMpService.getKefuService().sendKefuMessage(m);
            }
            catch (WxErrorException e) {
                logger.error("send message custom failed.", (Throwable)e);
            }
        }
    }
}

