/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.WechatTag;
import hls.support.core.wechat.service.IWechatTagService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WechatTagController
extends BaseController {
    @Autowired
    private IWechatTagService service;

    @RequestMapping(value={"/wechat/tag/query"})
    @ResponseBody
    public ResponseData query(WechatTag dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/wechat/tag/refresh"})
    @ResponseBody
    public ResponseData refresh(HttpServletRequest request, Long accountId) {
        IRequest reusetContext = this.createRequestContext(request);
        return this.service.refreshTag(reusetContext, accountId);
    }

    @RequestMapping(value={"/wechat/tag/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<WechatTag> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdateTag(requestCtx, dto));
    }

    @RequestMapping(value={"/wechat/tag/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<WechatTag> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/wechat/tag/queryTag"})
    @ResponseBody
    public ResponseData queryTag(HttpServletRequest request, WechatTag dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.queryTag(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/wechat/tag/addUsers"})
    @ResponseBody
    public ResponseData addTagUser(WechatTag tag, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.addTagUsers(requestContext, tag));
    }

    @RequestMapping(value={"/wechat/tag/removeUsers"})
    @ResponseBody
    public ResponseData removeTagUsers(WechatTag tag, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.removeTagUsers(requestContext, tag));
    }
}

