/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.WechatMenu;
import hls.support.core.wechat.service.IWechatMenuService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wechat/menu"})
public class WechatMenuController
extends BaseController {
    @Autowired
    private IWechatMenuService service;

    @RequestMapping(value={"/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<WechatMenu> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public ResponseData addMenu(@RequestBody WechatMenu dto, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.addMenu(requestCtx, dto);
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public ResponseData updateMenu(@RequestBody List<WechatMenu> wechatMenus, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.updateMenu(requestCtx, wechatMenus);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseData deleteMenu(@RequestBody WechatMenu dto, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        if (dto.getId() == null) {
            return new ResponseData(false);
        }
        return this.service.deleteMenu(requestCtx, dto);
    }

    @RequestMapping(value={"/query"})
    @ResponseBody
    public ResponseData queryMenu(WechatMenu dto, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.queryMenu(requestCtx, dto);
    }

    @RequestMapping(value={"/synchronize"})
    @ResponseBody
    public ResponseData synchronizeMenu(WechatMenu dto, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.synchronizeMenu(requestCtx, dto);
    }

    @RequestMapping(value={"/publish"})
    @ResponseBody
    public ResponseData publishMenu(WechatMenu dto, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.service.publishMenu(requestCtx, dto);
    }

    @RequestMapping(value={"/push"})
    public ResponseData pushMenus(Long accountId) {
        return this.service.pushMenus(accountId);
    }
}

