/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.WechatMember;
import hls.support.core.wechat.formbean.UserTag;
import hls.support.core.wechat.service.IWechatMemberService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WechatMemberController
extends BaseController {
    @Autowired
    private IWechatMemberService service;

    @RequestMapping(value={"/wechat/member/query/detail"})
    @ResponseBody
    public ResponseData queryDetail(WechatMember wechatMember, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.queryMemberDetail(requestContext, wechatMember, page, pageSize));
    }

    @RequestMapping(value={"/wechat/member/query"})
    @ResponseBody
    public ResponseData query(WechatMember dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/wechat/member/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<WechatMember> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdateMember(requestCtx, dto));
    }

    @RequestMapping(value={"/wechat/member/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<WechatMember> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/wechat/member/queryMemberByDepart"})
    @ResponseBody
    public ResponseData queryMemberByDepart(WechatMember dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = RequestHelper.getCurrentRequest();
        return new ResponseData(this.service.queryMemberByDepart(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/wechat/member/queryMemberByTag"})
    @ResponseBody
    public ResponseData queryMemberByTag(WechatMember dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = RequestHelper.getCurrentRequest();
        return new ResponseData(this.service.queryMemberByTag(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/wechat/member/queryMember"})
    @ResponseBody
    public ResponseData queryMember(WechatMember dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = RequestHelper.getCurrentRequest();
        if (dto.getTagId() != null) {
            return new ResponseData(this.service.queryMemberByTag(requestContext, dto, page, pageSize));
        }
        if (dto.getDepartmentId() != null) {
            return new ResponseData(this.service.queryMemberByDepart(requestContext, dto, page, pageSize));
        }
        return new ResponseData(this.service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/wechat/member/batchUpdateUserTag"})
    @ResponseBody
    public ResponseData batchAddTag(UserTag userTag, HttpServletRequest request) {
        IRequest requestCtx = RequestHelper.getCurrentRequest();
        if (userTag.getAccountId() == null || StringUtils.isEmpty((CharSequence)userTag.getMemberIds()) || userTag.getTagId() == null) {
            ResponseData responseData = new ResponseData();
            responseData.setSuccess(false);
            responseData.setMessage("one or more params is empty");
            return responseData;
        }
        return this.service.batchUpdateUserTag(requestCtx, userTag);
    }
}

