/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.NotificationTemplate;
import hls.support.core.wechat.service.INotificationTemplateService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class NotificationTemplateController
extends BaseController {
    @Autowired
    private INotificationTemplateService service;

    @RequestMapping(value={"/wechat/notification/template/query"})
    @ResponseBody
    public ResponseData query(NotificationTemplate dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.query(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/wechat/notification/template/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<NotificationTemplate> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/wechat/notification/template/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<NotificationTemplate> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/r/api/wechat/notification/template/sendNotication"})
    @ResponseBody
    public ResponseData sendNotication(HttpServletRequest request, @RequestBody Map map) {
        IRequest iRequest = this.createRequestContext(request);
        if (!map.containsKey("messages")) {
            ResponseData noMessagesData = new ResponseData(false);
            noMessagesData.setMessage("\u672a\u4f20messages\u53c2\u6570");
            return noMessagesData;
        }
        List list = (List)map.get("messages");
        if (list.size() > 0) {
            Boolean success = true;
            String message = "";
            for (int i = 0; i < list.size(); ++i) {
                ResponseData responseData = this.service.sendNotication(iRequest, (Map)list.get(i));
                if (responseData.isSuccess()) continue;
                success = false;
                message = message + "\u7b2c" + (i + 1) + "\u6761\u6a21\u677f\u4fe1\u606f\uff1a" + responseData.getMessage() + ";";
            }
            ResponseData responseMessage = new ResponseData(success);
            if (StringUtils.isNotEmpty((String)message)) {
                responseMessage.setMessage(message);
            }
            return responseMessage;
        }
        ResponseData responseDatas = new ResponseData(false);
        responseDatas.setMessage("Your param is wrong");
        return responseDatas;
    }
}

