/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.controllers;

import com.hand.hap.attachment.dto.SysFile;
import com.hand.hap.core.IRequest;
import com.hand.hap.security.TokenUtils;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.HlsWechatNoticeRecord;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.service.IHlsWechatNoticeRecordService;
import hls.support.core.wechat.service.IWechatAccountService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wechat/notice"})
public class HlsNoticeRecordController
extends BaseController {
    @Autowired
    private IHlsWechatNoticeRecordService hlsWechatNoticeRecordService;
    @Autowired
    private IWechatAccountService service;

    @RequestMapping(value={"/add"})
    @ResponseBody
    public List<HlsWechatNoticeRecord> addAccount(HlsWechatNoticeRecord dto, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return this.hlsWechatNoticeRecordService.addNotice(requestContext, dto);
    }

    @RequestMapping(value={"/enterprise/query"})
    @ResponseBody
    public List<WechatAccount> queryEnterpriseAccount(WechatEnterpriseApp dto, HttpServletRequest request) {
        return this.service.selectAll(this.createRequestContext(request));
    }

    @RequestMapping(value={"/query"})
    public ResponseData queryAccountsList(HlsWechatNoticeRecord dto, HttpServletRequest request, @RequestParam(value="page", required=false, defaultValue="1") int page, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize) {
        List<HlsWechatNoticeRecord> list = this.hlsWechatNoticeRecordService.select(this.createRequestContext(request), dto, page, pageSize);
        String securityKey = TokenUtils.getSecurityKey(request.getSession());
        SysFile file = new SysFile();
        for (HlsWechatNoticeRecord f : list) {
            file.setFileId(f.getFileId());
            f.set_token(TokenUtils.generateToken(securityKey, file));
        }
        return new ResponseData(list);
    }

    @RequestMapping(value={"/delete"})
    public ResponseData queryAccountsDelete(HlsWechatNoticeRecord dto, HttpServletRequest request) {
        return new ResponseData(this.hlsWechatNoticeRecordService.deleteByPrimaryKey(dto) > 0);
    }
}

