/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.AutoRecover;
import hls.support.core.wechat.service.IAutoRecoverService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AutoRecoverController
extends BaseController {
    @Autowired
    private IAutoRecoverService service;

    @RequestMapping(value={"/wx/auto/recover/query"})
    @ResponseBody
    public ResponseData query(AutoRecover dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/wx/auto/recover/seq/query"})
    @ResponseBody
    public ResponseData seqQuery(@RequestBody AutoRecover dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.selectSeq(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/wx/auto/recover/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<AutoRecover> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        for (int i = 0; i < dto.size(); ++i) {
            String reContent = dto.get(i).getReContent();
            dto.get(i).setReContent(StringEscapeUtils.unescapeHtml((String)StringEscapeUtils.escapeHtml((String)reContent)));
            dto.get(i).setReContent(dto.get(i).getReContent().replace("rgb(255, 255, 255)", "rgba(255, 255, 255,0)"));
        }
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/wx/auto/recover/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<AutoRecover> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }
}

