/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.sys.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.sys.bean.CommonMessageBean;
import hls.support.core.sys.service.ISysChannelSendService;
import hls.support.core.wechat.dto.NotificationContent;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.formbean.WxMessageBean;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.service.INotificationContentService;
import hls.support.core.wechat.service.IWechatMessageService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WxSendServiceImpl
implements ISysChannelSendService {
    private static final String ERROR_REQUIRED_PARAMETER_DATA_NULL = "ERROR_REQUIRED_PARAMETER_DATA_NULL";
    private static final Logger logger = LoggerFactory.getLogger(WxSendServiceImpl.class);
    @Autowired
    private IWechatMessageService wechatMessageService;
    @Autowired
    private WechatEnterpriseAppMapper wechatEnterpriseAppMapper;
    @Autowired
    INotificationContentService notificationContentService;
    @Value(value="#{configProperties['domain']}")
    private String domain;

    @Override
    public String getCode() {
        return "hls.support.core.sys.service.impl.WxSendServiceImpl";
    }

    @Override
    public ResponseData sendMsg(IRequest requestContext, CommonMessageBean messageBean) {
        ResponseData responseData = new ResponseData(false);
        WxMessageBean wxMessageBean = messageBean.getWxMessageBean();
        if (wxMessageBean == null) {
            logger.error(ERROR_REQUIRED_PARAMETER_DATA_NULL);
            responseData.setMessage(ERROR_REQUIRED_PARAMETER_DATA_NULL);
            return responseData;
        }
        List<WechatEnterpriseApp> listWechatApp = this.wechatEnterpriseAppMapper.queryInfoByCode(messageBean.getWxMessageBean().getTemplateId());
        NotificationContent notificationContent = new NotificationContent();
        notificationContent.setContent(messageBean.getContent());
        NotificationContent noticeContent = this.notificationContentService.insertSelective(requestContext, notificationContent);
        String url = this.domain + "weChat/wechat_notification_content.view?id=" + noticeContent.getId();
        wxMessageBean.setUrl(url);
        wxMessageBean.setAppId(listWechatApp.get(0).getId());
        wxMessageBean.setAccountId(listWechatApp.get(0).getAccountId());
        wxMessageBean.setWxCode(listWechatApp.get(0).getWxCode());
        wxMessageBean.setText(messageBean.getContent());
        wxMessageBean.setTemplateId(listWechatApp.get(0).getTemplateKey());
        System.out.println("*******************url\uff1a" + url);
        System.out.println("*******************id:" + listWechatApp.get(0).getId());
        System.out.println("*******************accountId:" + listWechatApp.get(0).getAccountId());
        System.out.println("*******************wxCode:" + listWechatApp.get(0).getWxCode());
        System.out.println("*******************content:" + messageBean.getContent());
        System.out.println("*******************TemplateKey:" + listWechatApp.get(0).getTemplateKey());
        responseData = this.wechatMessageService.sendTemplateText(wxMessageBean);
        return responseData;
    }
}

