/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.sys.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.sys.bean.CommonMessageBean;
import hls.support.core.sys.dto.SysChannelManage;
import hls.support.core.sys.service.ISysChannelManageService;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SysChannelManageController
extends BaseController {
    @Autowired
    private ISysChannelManageService sysChannelManageService;

    @RequestMapping(value={"/sys/channel/manage/query"})
    @ResponseBody
    public ResponseData query(SysChannelManage dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.sysChannelManageService.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/sys/channel/manage/save"})
    @ResponseBody
    public ResponseData save(@RequestBody List<SysChannelManage> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.sysChannelManageService.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/sys/channel/manage/update"})
    @ResponseBody
    public ResponseData update(@RequestBody List<SysChannelManage> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        this.sysChannelManageService.update(requestCtx, dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/sys/channel/manage/delete"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<SysChannelManage> dto) {
        this.sysChannelManageService.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/r/api/sys/channel/manage/send/notice", "/view/sys/channel/manage/send/notice"})
    @ResponseBody
    public List sendChannelNotice(HttpServletRequest request, @RequestBody List<CommonMessageBean> dtoList) throws ExecutionException, InterruptedException {
        IRequest requestCtx = this.createRequestContext(request);
        return this.sysChannelManageService.sendMsgByChannel(requestCtx, dtoList);
    }
}

