/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.hand.hap.cache.CacheDelete;
import com.hand.hap.cache.CacheSet;
import com.hand.hap.core.IRequest;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.system.dto.Prompt;
import com.hand.hap.system.service.IPromptService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PromptServiceImpl
extends BaseServiceImpl<Prompt>
implements IPromptService {
    @Autowired
    private IMessagePublisher messagePublisher;

    @Override
    @CacheSet(cache="prompt")
    public Prompt insertSelective(IRequest request, Prompt prompt) {
        super.insertSelective(request, prompt);
        this.notifyCache(prompt);
        return prompt;
    }

    @Override
    @CacheDelete(cache="prompt")
    public int deleteByPrimaryKey(Prompt prompt) {
        int result = super.deleteByPrimaryKey(prompt);
        this.notifyCache(prompt);
        return result;
    }

    @Override
    @CacheSet(cache="prompt")
    public Prompt updateByPrimaryKeySelective(IRequest request, Prompt prompt) {
        super.updateByPrimaryKeySelective(request, prompt);
        this.notifyCache(prompt);
        return prompt;
    }

    @Override
    @CacheSet(cache="prompt")
    public Prompt updateByPrimaryKey(IRequest request, Prompt prompt) {
        super.updateByPrimaryKey(request, prompt);
        this.notifyCache(prompt);
        return prompt;
    }

    private void notifyCache(Prompt prompt) {
        this.messagePublisher.publish("cache.prompt", prompt.getPromptCode());
    }
}

