/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.hand.hap.cache.impl.HotkeyCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.Hotkey;
import com.hand.hap.system.service.IHotkeyService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class HotkeyServiceImpl
extends BaseServiceImpl<Hotkey>
implements IHotkeyService {
    @Autowired
    private HotkeyCache hotkeyCache;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Hotkey insertSelective(IRequest request, Hotkey hotkey) {
        if (hotkey == null) {
            return null;
        }
        Hotkey hotkey1 = super.insertSelective(request, hotkey);
        this.hotkeyCache.load(hotkey1.getHotkeyLevel() + "_" + hotkey1.getHotkeyLevelId());
        return hotkey1;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Hotkey updateByPrimaryKeySelective(IRequest request, Hotkey hotkey) {
        if (hotkey == null) {
            return null;
        }
        Hotkey result = super.updateByPrimaryKeySelective(request, hotkey);
        this.hotkeyCache.load(result.getHotkeyLevel() + "_" + result.getHotkeyLevelId());
        return result;
    }

    @Override
    public int batchDelete(List<Hotkey> hotkeys) {
        int c = 0;
        String key = hotkeys.get(0).getHotkeyLevel() + "_" + hotkeys.get(0).getHotkeyLevelId();
        for (Hotkey hotkey : hotkeys) {
            c += ((IHotkeyService)this.self()).deleteByPrimaryKey(hotkey);
        }
        this.hotkeyCache.load(key);
        return c;
    }

    @Override
    public List<Hotkey> preferenceQuery(IRequest iRequest) {
        Hotkey hotkeyS = new Hotkey();
        hotkeyS.setHotkeyLevel("system");
        hotkeyS.setHotkeyLevelId(0L);
        List<Hotkey> hotkeySys = super.selectOptions(iRequest, hotkeyS, null);
        Hotkey hotkeyU = new Hotkey();
        hotkeyU.setHotkeyLevel("user");
        hotkeyU.setHotkeyLevelId(iRequest.getUserId());
        List<Hotkey> hotkeyUser = super.selectOptions(iRequest, hotkeyU, null);
        TreeMap<String, Hotkey> hotkeys = new TreeMap<String, Hotkey>();
        if (hotkeySys != null) {
            for (Hotkey hotkey : hotkeySys) {
                hotkeys.put(hotkey.getCode(), hotkey);
            }
        }
        if (hotkeyUser != null) {
            for (Hotkey hotkey : hotkeyUser) {
                Hotkey value = (Hotkey)hotkeys.get(hotkey.getCode());
                if (value == null) continue;
                hotkey.setDescription(value.getDescription());
                hotkeys.put(hotkey.getCode(), hotkey);
            }
        }
        ArrayList<Hotkey> datas = new ArrayList<Hotkey>();
        datas.addAll(hotkeys.values());
        return datas;
    }
}

