/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.cache.impl.SysCodeCache;
import com.hand.hap.core.ILanguageProvider;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.Code;
import com.hand.hap.system.dto.CodeValue;
import com.hand.hap.system.mapper.CodeMapper;
import com.hand.hap.system.mapper.CodeValueMapper;
import com.hand.hap.system.service.ICodeService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CodeServiceImpl
extends BaseServiceImpl<Code>
implements ICodeService {
    @Autowired
    private CodeMapper codeMapper;
    @Autowired
    private CodeValueMapper codeValueMapper;
    @Autowired
    private ILanguageProvider languageProvider;
    @Autowired
    private SysCodeCache codeCache;

    private void processCodeValues(Code code) {
        for (CodeValue codeValue : code.getCodeValues()) {
            if (codeValue.getCodeValueId() == null) {
                codeValue.setCodeId(code.getCodeId());
                this.codeValueMapper.insertSelective(codeValue);
                continue;
            }
            int count = this.codeValueMapper.updateByPrimaryKey(codeValue);
            this.checkOvn(count, codeValue);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<Code> selectCodes(IRequest request, Code code, int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        List<Code> codes = this.codeMapper.selectCodes(code);
        return codes;
    }

    @Override
    public List<CodeValue> selectCodeValues(IRequest request, CodeValue value) {
        return this.codeValueMapper.selectCodeValuesByCodeId(value);
    }

    @Override
    public List<CodeValue> selectCodeValuesByCodeName(IRequest request, String codeName) {
        Code code = this.codeCache.getValue(codeName + "." + request.getLocale());
        if (code != null) {
            return code.getCodeValues();
        }
        return this.codeValueMapper.selectCodeValuesByCodeName(codeName);
    }

    @Override
    public CodeValue getCodeValue(IRequest request, String codeName, String value) {
        Code code = this.codeCache.getValue(codeName + "." + request.getLocale());
        if (code == null) {
            return null;
        }
        if (code.getCodeValues() == null) {
            return null;
        }
        for (CodeValue v : code.getCodeValues()) {
            if (!value.equals(v.getValue())) continue;
            return v;
        }
        return null;
    }

    @Override
    public String getCodeValueByMeaning(IRequest request, String codeName, String meaning) {
        Code code = this.codeCache.getValue(codeName + "." + request.getLocale());
        if (code == null) {
            return null;
        }
        if (code.getCodeValues() == null) {
            return null;
        }
        for (CodeValue v : code.getCodeValues()) {
            if (!meaning.equals(v.getMeaning())) continue;
            return v.getValue();
        }
        return null;
    }

    @Override
    public String getCodeMeaningByValue(IRequest request, String codeName, String value) {
        Code code = this.codeCache.getValue(codeName + "." + request.getLocale());
        if (code == null) {
            return null;
        }
        if (code.getCodeValues() == null) {
            return null;
        }
        for (CodeValue v : code.getCodeValues()) {
            if (!value.equals(v.getValue())) continue;
            return v.getMeaning();
        }
        return null;
    }

    @Override
    public String getCodeDescByValue(IRequest request, String codeName, String value) {
        Code code = this.codeCache.getValue(codeName + "." + request.getLocale());
        if (code == null) {
            return null;
        }
        if (code.getCodeValues() == null) {
            return null;
        }
        for (CodeValue v : code.getCodeValues()) {
            if (!value.equals(v.getValue())) continue;
            return v.getDescription();
        }
        return null;
    }

    @Override
    public List<CodeValue> getCodeValuesByCode(IRequest request, String codeName) {
        Code code = this.codeCache.getValue(codeName + "." + request.getLocale());
        if (code != null && "Y".equals(code.getEnabledFlag())) {
            return this.getEnabledCodeValues(code);
        }
        return null;
    }

    @Override
    public List<CodeValue> getChildCodeValue(IRequest request, String codeName, String value) {
        CodeValue codeValue = this.getCodeValue(request, codeName, value);
        if (codeValue != null) {
            return this.codeValueMapper.selectCodeValuesByParentId(codeValue.getCodeValueId());
        }
        return null;
    }

    @Override
    public Code createCode(Code code) {
        this.codeMapper.insertSelective(code);
        if (code.getCodeValues() != null) {
            this.processCodeValues(code);
        }
        this.codeCache.reload(code.getCodeId());
        return code;
    }

    @Override
    public boolean batchDelete(IRequest request, List<Code> codes) {
        for (Code code : codes) {
            CodeValue codeValue = new CodeValue();
            codeValue.setCodeId(code.getCodeId());
            this.codeValueMapper.deleteTlByCodeId(codeValue);
            this.codeValueMapper.deleteByCodeId(codeValue);
            int updateCount = this.codeMapper.deleteByPrimaryKey(code);
            this.checkOvn(updateCount, code);
            this.codeCache.remove(code.getCode());
        }
        return true;
    }

    @Override
    public boolean batchDeleteValues(IRequest request, List<CodeValue> values) {
        HashSet<Long> codeIdSet = new HashSet<Long>();
        for (CodeValue value : values) {
            int updateCount = this.codeValueMapper.deleteByPrimaryKey(value);
            this.checkOvn(updateCount, value);
            codeIdSet.add(value.getCodeId());
        }
        for (Long codeId : codeIdSet) {
            this.codeCache.reload(codeId);
        }
        return true;
    }

    @Override
    public Code updateCode(Code code) {
        int count = this.codeMapper.updateByPrimaryKey(code);
        this.checkOvn(count, code);
        if (code.getCodeValues() != null) {
            this.processCodeValues(code);
        }
        this.codeCache.remove(code.getCode());
        this.codeCache.reload(code.getCodeId());
        return code;
    }

    @Override
    public List<Code> batchUpdate(IRequest request, List<Code> codes) {
        for (Code code : codes) {
            if (code.getCodeId() == null) {
                ((ICodeService)this.self()).createCode(code);
                continue;
            }
            ((ICodeService)this.self()).updateCode(code);
        }
        return codes;
    }

    private List<CodeValue> getEnabledCodeValues(Code code) {
        ArrayList<CodeValue> enabledCodeValues = new ArrayList<CodeValue>();
        List<CodeValue> allCodeValues = code.getCodeValues();
        if (allCodeValues != null) {
            for (CodeValue codevalue : allCodeValues) {
                if (!"Y".equals(codevalue.getEnabledFlag())) continue;
                enabledCodeValues.add(codevalue);
            }
        }
        return enabledCodeValues;
    }
}

