/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.core.exception.UpdateFailedException;
import com.hand.hap.extensible.components.ServiceListenerChainFactory;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.mybatis.common.Mapper;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.service.IBaseService;
import java.util.List;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public abstract class BaseServiceImpl<T>
implements IBaseService<T> {
    @Autowired
    protected Mapper<T> mapper;
    @Autowired
    private ServiceListenerChainFactory chainFactory;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<T> select(IRequest request, T condition, int pageNum, int pageSize) {
        PageHelper.startPage(pageNum, pageSize);
        return this.mapper.select(condition);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public T insert(IRequest request, T record) {
        record = this.chainFactory.getChain(this).beforeInsert(request, record);
        this.mapper.insert(record);
        record = this.chainFactory.getChain(this).afterInsert(request, record);
        return record;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public T insertSelective(IRequest request, T record) {
        record = this.chainFactory.getChain(this).beforeInsert(request, record);
        this.mapper.insertSelective(record);
        record = this.chainFactory.getChain(this).afterInsert(request, record);
        return record;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public T updateByPrimaryKey(IRequest request, @StdWho T record) {
        record = this.chainFactory.getChain(this).beforeUpdate(request, record);
        int ret = this.mapper.updateByPrimaryKey(record);
        this.checkOvn(ret, record);
        record = this.chainFactory.getChain(this).afterUpdate(request, record);
        return record;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public T updateByPrimaryKeySelective(IRequest request, @StdWho T record) {
        record = this.chainFactory.getChain(this).beforeUpdate(request, record);
        int ret = this.mapper.updateByPrimaryKeySelective(record);
        this.checkOvn(ret, record);
        record = this.chainFactory.getChain(this).afterUpdate(request, record);
        return record;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public T updateByPrimaryKeyOptions(IRequest request, @StdWho T record, Criteria criteria) {
        record = this.chainFactory.getChain(this).beforeUpdate(request, record);
        int ret = this.mapper.updateByPrimaryKeyOptions(record, criteria);
        this.checkOvn(ret, record);
        record = this.chainFactory.getChain(this).afterUpdate(request, record);
        return record;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public T selectByPrimaryKey(IRequest request, T record) {
        return this.mapper.selectByPrimaryKey(record);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deleteByPrimaryKey(T record) {
        record = this.chainFactory.getChain(this).beforeDelete(null, record);
        int ret = this.mapper.deleteByPrimaryKey(record);
        this.checkOvn(ret, record);
        record = this.chainFactory.getChain(this).afterDelete(null, record);
        return ret;
    }

    protected void checkOvn(int updateCount, Object record) {
        BaseDTO baseDTO;
        if (updateCount == 0 && record instanceof BaseDTO && (baseDTO = (BaseDTO)record).getObjectVersionNumber() != null) {
            throw new RuntimeException(new UpdateFailedException(baseDTO));
        }
    }

    @Override
    @Deprecated
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<T> selectAll() {
        return this.mapper.selectAll();
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<T> selectAll(IRequest request) {
        return this.mapper.selectAll();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<T> batchUpdate(IRequest request, List<T> list) {
        IBaseService self = (IBaseService)AopContext.currentProxy();
        for (T t : list) {
            switch (((BaseDTO)t).get__status()) {
                case "add": {
                    self.insertSelective(request, t);
                    break;
                }
                case "update": {
                    if (this.useSelectiveUpdate()) {
                        self.updateByPrimaryKeySelective(request, t);
                        break;
                    }
                    self.updateByPrimaryKey(request, t);
                    break;
                }
                case "delete": {
                    self.deleteByPrimaryKey(t);
                    break;
                }
            }
        }
        return list;
    }

    protected boolean useSelectiveUpdate() {
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(List<T> list) {
        IBaseService self = (IBaseService)AopContext.currentProxy();
        int c = 0;
        for (T t : list) {
            c += self.deleteByPrimaryKey(t);
        }
        return c;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<T> selectOptions(IRequest request, T record, Criteria criteria) {
        if (criteria == null) {
            criteria = new Criteria(record);
        }
        IBaseService self = (IBaseService)AopContext.currentProxy();
        return self.selectOptions(request, record, criteria, null, null);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<T> selectOptions(IRequest request, T record, Criteria criteria, Integer pageNum, Integer pageSize) {
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage(pageNum, pageSize);
        }
        if (criteria == null) {
            criteria = new Criteria(record);
        }
        List<T> list = this.mapper.selectOptions(record, criteria);
        return list;
    }
}

