/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.hand.hap.cache.impl.ResourceItemAssignCache;
import com.hand.hap.cache.impl.ResourceItemCache;
import com.hand.hap.cache.impl.ResourceItemElementCache;
import com.hand.hap.cache.impl.RoleFunctionCache;
import com.hand.hap.cache.impl.RoleResourceItemCache;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.function.dto.ResourceItem;
import com.hand.hap.function.dto.ResourceItemAssign;
import com.hand.hap.function.dto.ResourceItemElement;
import com.hand.hap.function.mapper.RoleFunctionMapper;
import com.hand.hap.function.service.IResourceItemService;
import com.hand.hap.function.service.IResourceService;
import com.hand.hap.function.service.IRoleResourceItemService;
import com.hand.hap.system.service.IAccessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.logstash.logback.encoder.org.apache.commons.lang.ArrayUtils;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@Scope(value="prototype")
public class AccessServiceImpl
implements IAccessService {
    private static final String ACTION_MAINTAIN = "MAINTAIN";
    private Logger logger = LoggerFactory.getLogger(AccessServiceImpl.class);
    private HttpServletRequest request;
    @Autowired
    private IResourceService resourceService;
    @Autowired
    private IResourceItemService resourceItemService;
    @Autowired
    private IRoleResourceItemService roleResourceItemService;
    @Autowired
    private RoleFunctionMapper roleFunctionMapper;
    @Autowired
    private ResourceItemCache resourceItemCache;
    @Autowired
    private RoleResourceItemCache roleResourceItemCache;
    @Autowired
    private ResourceItemAssignCache resourceItemAssignCache;
    @Autowired
    private ResourceItemElementCache resourceItemElementCache;
    @Autowired
    private RoleFunctionCache roleFunctionCache;

    @Override
    public boolean accessMaintain() {
        return ((IAccessService)this.self()).access(ACTION_MAINTAIN);
    }

    @Override
    @Deprecated
    public String createNotAccessItemStyles() {
        List<String> list;
        String contextPath;
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String requestUri = request.getRequestURI();
        String url = requestUri.substring((contextPath = request.getContextPath()).length() + 1);
        Resource resource = this.resourceService.selectResourceByUrl(url);
        if (resource != null && (list = this.roleResourceItemService.getNotAccessItems(resource, this.getRoleId())) != null && list.size() != 0) {
            StringBuilder items = new StringBuilder();
            items.append("<style type=\"text/css\">");
            for (int i = 0; i < list.size(); ++i) {
                if (i == list.size() - 1) {
                    items.append("#" + list.get(i) + " {display: none}");
                    items.append("</style>");
                    break;
                }
                items.append("#" + list.get(i) + ",");
            }
            return items.toString();
        }
        return "";
    }

    @Override
    public boolean access(String accessCode) {
        String contextPath;
        HttpServletRequest request;
        String requestUri;
        String url;
        Resource resource;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("userId: {} accessCode:{}", (Object)this.getUserId(), (Object)accessCode.toString());
        }
        if ((resource = this.resourceService.selectResourceByUrl(url = (requestUri = (request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest()).getRequestURI()).substring((contextPath = request.getContextPath()).length() + 1))) != null) {
            Object[] resourceItems = this.resourceItemCache.getValue(resource.getResourceId().toString());
            Object[] resourceItemIds = this.roleResourceItemCache.getValue(this.getRoleId().toString());
            Long accessResourceItemId = null;
            if (ArrayUtils.isNotEmpty((Object[])resourceItems)) {
                for (Object resourceItem : resourceItems) {
                    if (!((ResourceItem)resourceItem).getItemId().equals(accessCode)) continue;
                    accessResourceItemId = ((ResourceItem)resourceItem).getResourceItemId();
                    break;
                }
            }
            if (ArrayUtils.isNotEmpty((Object[])resourceItemIds)) {
                for (Object resourceItemId : resourceItemIds) {
                    if (!((Long)resourceItemId).equals(accessResourceItemId)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String accessData() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String requestUri = request.getRequestURI();
        String contextPath = request.getContextPath();
        String url = requestUri.substring(contextPath.length() + 1);
        Resource resource = this.resourceService.selectResourceByUrl(url);
        HashMap accessData = new HashMap();
        List<Long> assignElementIds = null;
        ResourceItem[] resourceItems = null;
        if (resource != null) {
            assignElementIds = this.getAllAssignElementIds();
            resourceItems = this.resourceItemCache.getValue(resource.getResourceId().toString());
        }
        if (ArrayUtils.isEmpty(resourceItems) || CollectionUtils.isEmpty(assignElementIds)) {
            return ((Object)accessData).toString();
        }
        return this.buildAccessData(accessData, resourceItems, assignElementIds);
    }

    private String buildAccessData(Map accessData, ResourceItem[] resourceItems, List<Long> assignElementIds) {
        accessData.put("buttons", new ArrayList());
        accessData.put("grid", new ArrayList());
        accessData.put("form", new ArrayList());
        for (ResourceItem resourceItem : resourceItems) {
            ResourceItemElement[] elements = this.resourceItemElementCache.getValue(resourceItem.getResourceItemId().toString());
            if (elements == null) continue;
            block1: for (ResourceItemElement element : elements) {
                for (Long assignElementId : assignElementIds) {
                    if (!element.getElementId().equals(assignElementId)) continue;
                    this.buildElements(resourceItem, element, accessData);
                    continue block1;
                }
            }
        }
        return JSONObject.fromObject((Object)accessData).toString();
    }

    private void buildElements(ResourceItem resourceItem, ResourceItemElement element, Map accessData) {
        String type = resourceItem.getItemType();
        String itemId = resourceItem.getItemId();
        if ("buttons".equalsIgnoreCase(type)) {
            this.buildElement(element.getProperty(), element.getPropertyValue(), accessData, "buttons");
        } else if ("form".equalsIgnoreCase(type)) {
            List formList = (List)accessData.get("form");
            Map form = null;
            for (Map map : formList) {
                String id = (String)map.get("id");
                if (!id.equals(itemId)) continue;
                form = map;
                break;
            }
            if (form == null) {
                form = new HashMap<String, Object>();
                form.put("id", itemId);
                form.put("fields", new ArrayList());
                form.put("buttons", new ArrayList());
                formList.add(form);
            }
            if ("form-buttons".equalsIgnoreCase(element.getType())) {
                this.buildElement(element.getProperty(), element.getPropertyValue(), form, "fields");
            } else if ("form-field".equalsIgnoreCase(element.getType())) {
                this.buildElement(element.getProperty(), element.getPropertyValue(), form, "buttons");
            }
        } else if ("grid".equalsIgnoreCase(type)) {
            List gridList = (List)accessData.get("grid");
            Map grid = null;
            for (Map map : gridList) {
                String id = (String)map.get("id");
                if (!id.equals(itemId)) continue;
                grid = map;
                break;
            }
            if (grid == null) {
                grid = new HashMap<String, Object>();
                grid.put("id", itemId);
                grid.put("buttons", new ArrayList());
                grid.put("columnButtons", new ArrayList());
                grid.put("columns", new ArrayList());
                gridList.add(grid);
            }
            if ("grid-buttons".equalsIgnoreCase(element.getType())) {
                this.buildElement(element.getProperty(), element.getPropertyValue(), grid, "buttons");
            } else if ("column-buttons".equalsIgnoreCase(element.getType())) {
                this.buildElement(element.getProperty(), element.getPropertyValue(), grid, "columnButtons");
            } else if ("column".equalsIgnoreCase(element.getType())) {
                this.buildElement(element.getProperty(), element.getPropertyValue(), grid, "columns");
            }
        }
    }

    private void buildElement(String property, String propertyValue, Map accessData, String name) {
        List btnMap = (List)accessData.get(name);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(property, propertyValue);
        btnMap.add(map);
    }

    private List<Long> getAllAssignElementIds() {
        ArrayList<Long> allAssignElementIds = new ArrayList<Long>();
        if (this.getUserId() != null) {
            List<Long> roleAssignElementIds = this.getAllRoleAssignElementIds();
            Object[] userAssigns = this.resourceItemAssignCache.getValue("user_" + this.getUserId());
            if (ArrayUtils.isEmpty((Object[])userAssigns)) {
                if (CollectionUtils.isNotEmpty(roleAssignElementIds)) {
                    allAssignElementIds.addAll(roleAssignElementIds);
                }
                return allAssignElementIds;
            }
            for (Object assign : userAssigns) {
                if (!"N".equalsIgnoreCase(((ResourceItemAssign)assign).getEnable())) continue;
                allAssignElementIds.add(((ResourceItemAssign)assign).getElementId());
            }
            if (CollectionUtils.isNotEmpty(roleAssignElementIds)) {
                for (Long roleAssignElementId : roleAssignElementIds) {
                    boolean check = true;
                    for (Object userAssign : userAssigns) {
                        if (!roleAssignElementId.equals(((ResourceItemAssign)userAssign).getElementId())) continue;
                        check = false;
                        break;
                    }
                    if (!check) continue;
                    allAssignElementIds.add(roleAssignElementId);
                }
            }
        }
        return allAssignElementIds;
    }

    private List<Long> getAllRoleAssignElementIds() {
        Object[] roleIds = this.getRoleIds();
        if (ArrayUtils.isEmpty((Object[])roleIds)) {
            return null;
        }
        ArrayList<Long> allRoleAssignElementIds = new ArrayList<Long>();
        Map<Object, Object> allFunctionElements = new HashMap<Long, List>();
        boolean firstRole = true;
        HashSet<Long> allRoleFunctions = new HashSet<Long>();
        for (Object roleId : roleIds) {
            Object[] roleFunctionList = this.roleFunctionCache.getValue(((Long)roleId).toString());
            if (ArrayUtils.isEmpty((Object[])roleFunctionList)) continue;
            HashSet<Long> roleFunctions = new HashSet<Long>();
            for (Object function : roleFunctionList) {
                roleFunctions.add((Long)function);
            }
            Map<Long, List<Long>> functionElements = this.getFunctionElements(this.resourceItemAssignCache.getValue("role_" + roleId));
            if (firstRole) {
                firstRole = false;
                allRoleFunctions = roleFunctions;
                allFunctionElements = functionElements;
                continue;
            }
            List<Long> sameFunctions = this.getSameFunctions(allRoleFunctions, roleFunctions);
            for (Long roleFunction : roleFunctions) {
                boolean same = false;
                for (Long sameFunction : sameFunctions) {
                    if (!roleFunction.equals(sameFunction)) continue;
                    same = true;
                    break;
                }
                if (same) continue;
                allFunctionElements.put(roleFunction, functionElements.get(roleFunction));
            }
            for (Long sameFunction : sameFunctions) {
                List<Long> elements = this.compareFunctionElements((List)allFunctionElements.get(sameFunction), functionElements.get(sameFunction));
                allFunctionElements.put(sameFunction, elements);
            }
            allRoleFunctions.addAll(roleFunctions);
        }
        allFunctionElements.forEach((k, v) -> {
            if (CollectionUtils.isNotEmpty((Collection)v)) {
                for (Long assignElementId : v) {
                    allRoleAssignElementIds.add(assignElementId);
                }
            }
        });
        return allRoleAssignElementIds;
    }

    private Map<Long, List<Long>> getFunctionElements(ResourceItemAssign[] assigns) {
        HashMap<Long, List<Long>> function = new HashMap<Long, List<Long>>();
        if (ArrayUtils.isNotEmpty((Object[])assigns)) {
            for (ResourceItemAssign assign : assigns) {
                ArrayList<Long> functionElements = (ArrayList<Long>)function.get(assign.getFunctionId());
                if (CollectionUtils.isEmpty((Collection)functionElements)) {
                    functionElements = new ArrayList<Long>();
                    function.put(assign.getFunctionId(), functionElements);
                }
                functionElements.add(assign.getElementId());
            }
        }
        return function;
    }

    private List<Long> getSameFunctions(Set<Long> allRoleFunctions, Set<Long> roleFunctions) {
        ArrayList<Long> sameFunctions = new ArrayList<Long>();
        for (Long allRoleFunction : allRoleFunctions) {
            for (Long roleFunction : roleFunctions) {
                if (!allRoleFunction.equals(roleFunction)) continue;
                sameFunctions.add(allRoleFunction);
            }
        }
        return sameFunctions;
    }

    private List<Long> compareFunctionElements(List<Long> allFunctionElements, List<Long> functionElements) {
        if (CollectionUtils.isEmpty(allFunctionElements) || CollectionUtils.isEmpty(functionElements)) {
            return new ArrayList<Long>();
        }
        allFunctionElements.retainAll(functionElements);
        return allFunctionElements;
    }

    @Override
    public boolean accessFunction(String functionCode) {
        Long roleId = this.getRoleId();
        int result = this.roleFunctionMapper.selectCountByFunctionCode(roleId, functionCode);
        return result > 0;
    }

    private Long getUserId() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            return (Long)session.getAttribute("userId");
        }
        return null;
    }

    private Long getRoleId() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            return (Long)session.getAttribute("roleId");
        }
        return null;
    }

    private Long[] getRoleIds() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            return (Long[])session.getAttribute("roleIds");
        }
        return null;
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

