/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers.sys;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.mybatis.util.SqlMapper;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ParameterConfig;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.IParameterConfigService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/parameter/config", "/api/sys/parameter/config"})
public class ParameterConfigController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(ParameterConfigController.class);
    @Autowired
    @Qualifier(value="sqlSessionFactory")
    private SqlSessionFactory sqlSessionFactory;
    @Autowired
    private IParameterConfigService parameterConfigService;

    @RequestMapping(value={"/query"})
    @ResponseBody
    public ResponseData query(HttpServletRequest request, @RequestParam(required=false) String code, @RequestParam(required=false) Long targetId) {
        IRequest iRequest = RequestHelper.createServiceRequest(request);
        ParameterConfig parameterConfig = new ParameterConfig();
        parameterConfig.setCode(code);
        parameterConfig.setTargetId(targetId);
        return new ResponseData(this.parameterConfigService.selectOptions(iRequest, parameterConfig, null));
    }

    @RequestMapping(value={"/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<ParameterConfig> parameterConfigs, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(parameterConfigs, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.parameterConfigService.batchUpdate(requestCtx, parameterConfigs));
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<ParameterConfig> parameterConfigs) {
        this.parameterConfigService.batchDelete(parameterConfigs);
        return new ResponseData();
    }

    @RequestMapping(value={"/queryReportParameter"})
    @ResponseBody
    public ResponseData queryByReportCode(HttpServletRequest request, @RequestParam(required=false) String reportCode) {
        IRequest iRequest = this.createRequestContext(request);
        List<ParameterConfig> parameterConfigs = this.parameterConfigService.selectByReportCode(reportCode);
        return this.parseParameter(iRequest, parameterConfigs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/checkDefaultValue"})
    @ResponseBody
    public ResponseData checkDefaultValue(HttpServletRequest request, @RequestBody String sql) {
        ResponseData responseData = null;
        if (!StringUtils.isNotEmpty((CharSequence)sql)) return responseData;
        IRequest requestContext = this.createRequestContext(request);
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            responseData = new ResponseData();
            Map<String, String> result = this.getValueAndText(requestContext, sqlSession, sql);
            responseData.setMessage("\u9ed8\u8ba4Value: " + result.get("defaultValue") + "<br><br>\u9ed8\u8ba4Text: " + result.get("defaultText"));
            ResponseData responseData2 = responseData;
            return responseData2;
        }
        catch (Throwable e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getMessage(), e);
            }
            responseData = new ResponseData(false);
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    private ResponseData parseParameter(IRequest request, List<ParameterConfig> parameterConfigs) {
        if (CollectionUtils.isNotEmpty(parameterConfigs)) {
            for (ParameterConfig parameterConfig : parameterConfigs) {
                if ("sql".equalsIgnoreCase(parameterConfig.getDefaultType()) && StringUtils.isNotEmpty((CharSequence)parameterConfig.getDefaultValue())) {
                    try {
                        SqlSession sqlSession = this.sqlSessionFactory.openSession();
                        Throwable throwable = null;
                        try {
                            Map<String, String> result = this.getValueAndText(request, sqlSession, parameterConfig.getDefaultValue());
                            parameterConfig.setDefaultText(result.get("defaultText"));
                            parameterConfig.setDefaultValue(result.get("defaultValue"));
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (sqlSession == null) continue;
                            if (throwable != null) {
                                try {
                                    sqlSession.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            sqlSession.close();
                            continue;
                        }
                    }
                    catch (Throwable e) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error(e.getMessage(), e);
                        }
                        ResponseData responseData = new ResponseData(false);
                        responseData.setMessage("\u53c2\u6570[" + parameterConfig.getTableFieldName() + "]  \u9ed8\u8ba4\u503csql\u51fa\u9519:<br><br>" + e.getMessage());
                        return responseData;
                    }
                }
                if (!"currentDate".equalsIgnoreCase(parameterConfig.getDefaultType())) continue;
                Date today = new Date();
                parameterConfig.setDefaultValue(new SimpleDateFormat("yyyy-MM-dd").format(today));
            }
        }
        return new ResponseData(parameterConfigs);
    }

    private Map<String, String> getValueAndText(IRequest request, SqlSession sqlSession, String sql) {
        HashMap<String, String> result = new HashMap<String, String>();
        SqlMapper sqlMapper = new SqlMapper(sqlSession);
        List<HashMap> results = sqlMapper.selectList("<script>\n\t" + sql + "</script>", request, HashMap.class);
        String defaultValue = "";
        String defaultText = "";
        if (results.size() == 1) {
            defaultValue = this.getValue(results.get(0));
            defaultText = this.getText(results.get(0));
        } else if (results.size() > 1) {
            for (HashMap map : results) {
                defaultValue = defaultValue + this.getValue(map) + ",";
            }
        }
        result.put("defaultValue", defaultValue);
        result.put("defaultText", defaultText);
        return result;
    }

    private String getValue(HashMap map) {
        if (null == map.get("value") && null == map.get("VALUE")) {
            return "";
        }
        if (map.get("value") != null) {
            return map.get("value").toString();
        }
        if (map.get("VALUE") != null) {
            return map.get("VALUE").toString();
        }
        return "";
    }

    private String getText(HashMap map) {
        if (null == map.get("text") && null == map.get("TEXT")) {
            return "";
        }
        if (map.get("text") != null) {
            return map.get("text").toString();
        }
        if (map.get("TEXT") != null) {
            return map.get("TEXT").toString();
        }
        return "";
    }
}

