/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers.sys;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.Lov;
import com.hand.hap.system.dto.LovItem;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.IKendoLovService;
import com.hand.hap.system.service.ILovService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys", "/api/sys"})
public class LovController
extends BaseController {
    @Autowired
    private ILovService lovService;
    @Autowired
    private IKendoLovService kendoLovService;

    @RequestMapping(value={"/lovitem/query"})
    @ResponseBody
    public ResponseData getLovItems(LovItem item, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.lovService.selectLovItems(requestContext, item));
    }

    @RequestMapping(value={"/lov/query"})
    @ResponseBody
    public ResponseData queryLov(Lov lov, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.lovService.selectLovs(requestContext, lov, page, pagesize));
    }

    @RequestMapping(value={"/lov/getLovByCustomCode"})
    @ResponseBody
    public String getLovByCustomCode(@RequestParam(value="contextPath") String contextPath, @RequestParam(value="locale") Locale locale, @RequestParam(value="lovCode") String lovCode) {
        return this.kendoLovService.getLov(contextPath, locale, lovCode);
    }

    @RequestMapping(value={"/lov/load"})
    @ResponseBody
    public ResponseData loadLov(@RequestParam Long lovId, HttpServletRequest request) {
        ArrayList<Lov> list = new ArrayList<Lov>();
        list.add(this.lovService.loadLov(lovId));
        return new ResponseData(list);
    }

    @RequestMapping(value={"/lov/remove"}, method={RequestMethod.POST})
    public ResponseData removeLov(@RequestBody List<Lov> items) {
        this.lovService.batchDeleteLov(items);
        return new ResponseData();
    }

    @RequestMapping(value={"/lovitem/remove"}, method={RequestMethod.POST})
    public ResponseData removeLovItems(@RequestBody List<LovItem> items) {
        this.lovService.batchDeleteItems(items);
        return new ResponseData();
    }

    @RequestMapping(value={"/lov/submit"}, method={RequestMethod.POST})
    public ResponseData submitLov(HttpServletRequest request, @RequestBody List<Lov> lovs, BindingResult result) {
        this.getValidator().validate(lovs, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.lovService.batchUpdate(requestContext, lovs));
    }
}

