/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers.sys;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.Language;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.ILanguageService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/language", "/api/sys/language"})
public class LanguageController
extends BaseController {
    @Autowired
    private ILanguageService languageService;

    @RequestMapping(value={"/query"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData query(HttpServletRequest request, Language example, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.languageService.select(iRequest, example, page, pagesize));
    }

    @RequestMapping(value={"/submit"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData submit(HttpServletRequest request, @RequestBody List<Language> languageList, BindingResult result) {
        this.getValidator().validate(languageList, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rs = new ResponseData(false);
            rs.setMessage(this.getErrorMessage((Errors)result, request));
            return rs;
        }
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.languageService.submit(iRequest, languageList));
    }

    @RequestMapping(value={"/remove", "/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<Language> languageList) {
        this.languageService.remove(languageList);
        return new ResponseData();
    }
}

