/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.service.impl;

import com.hand.hap.account.dto.User;
import com.hand.hap.account.exception.RoleException;
import com.hand.hap.account.service.IRole;
import com.hand.hap.account.service.IRoleService;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.activiti.listeners.TaskCreateNotificationListener;
import com.hand.hap.core.components.CaptchaConfig;
import com.hand.hap.core.components.SysConfigManager;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.core.util.TimeZoneUtil;
import com.hand.hap.hr.service.IEmployeeAssignService;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.message.websocket.CommandMessage;
import com.hand.hap.message.websocket.WebSocketSessionManager;
import com.hand.hap.security.IAuthenticationSuccessListener;
import com.hand.hap.security.PasswordManager;
import com.hand.hap.security.TokenUtils;
import com.hand.hap.security.service.impl.UserSecurityStrategyManager;
import com.hand.hap.system.dto.SysPreferences;
import com.hand.hap.system.service.ISysPreferencesService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestFactory;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.WebUtils;

@Component
public class DefaultAuthenticationSuccessListener
implements IAuthenticationSuccessListener {
    @Autowired
    IUserService userService;
    @Autowired
    @Qualifier(value="roleServiceImpl")
    private IRoleService roleService;
    @Autowired
    ISysPreferencesService preferencesService;
    @Autowired
    IEmployeeAssignService employeeAssignService;
    @Autowired
    CaptchaConfig captchaConfig;
    @Autowired
    PasswordManager passwordManager;
    @Autowired
    SysConfigManager sysConfigManager;
    @Autowired
    UserSecurityStrategyManager userSecurityStrategyManager;
    @Autowired
    private WebSocketSessionManager webSocketSessionManager;
    @Autowired
    private AuthorizationServerTokenServices tokenServices;
    @Autowired
    private DefaultOAuth2RequestFactory defaultOAuth2RequestFactory;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    public IMessagePublisher iMessagePublisher;
    @Autowired
    private TaskCreateNotificationListener taskCreateNotificationListener;
    private static final String HAP_LOGIN_USER = "hap:cache:login:";

    @Override
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        UserDetails userDetails = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = this.userService.selectByUserName(userDetails.getUsername());
        HttpSession session = request.getSession(true);
        this.processRepeatLogin(user, session);
        session.setAttribute("userId", (Object)user.getUserId());
        session.setAttribute("userName", (Object)user.getUserName());
        session.setAttribute("locale", (Object)locale.toString());
        this.setTimeZoneFromPreference(request, user.getUserId());
        this.setNavFromPreference(session, user.getUserId());
        this.setLocalePreference(request, user.getUserId());
        this.setRoleInfo(request, session, user);
        this.setProcessUser(user, session);
        this.setCompany(user, session);
        this.generateSecurityKey(session);
        this.generateAccessToken(authentication, session);
        this.fetchSystemImageVersion(request);
        this.captchaConfig.resetLoginFailureInfo(request, response);
    }

    private void fetchSystemImageVersion(HttpServletRequest request) {
        WebUtils.setSessionAttribute((HttpServletRequest)request, (String)"sysLogoVersion", (Object)this.sysConfigManager.getSystemLogoVersion());
        WebUtils.setSessionAttribute((HttpServletRequest)request, (String)"sysFaviconVersion", (Object)this.sysConfigManager.getSystemFaviconVersion());
    }

    private void generateAccessToken(Authentication authentication, HttpSession session) {
        HashMap<String, String> authorizationParameters = new HashMap<String, String>();
        authorizationParameters.put("client_id", "HAP_INNER_CLIENT_ID");
        authorizationParameters.put("client_secret", "2d6be1aa-5e3b-4b03-b8c9-d553ea276a05");
        authorizationParameters.put("grant_type", "password");
        AuthorizationRequest authorizationRequest = this.defaultOAuth2RequestFactory.createAuthorizationRequest(authorizationParameters);
        OAuth2Request oAuth2Request = this.defaultOAuth2RequestFactory.createOAuth2Request(authorizationRequest);
        OAuth2Authentication oAuth2Authentication = new OAuth2Authentication(oAuth2Request, authentication);
        OAuth2AccessToken oAuth2AccessToken = this.tokenServices.createAccessToken(oAuth2Authentication);
        session.setAttribute("access_token", (Object)oAuth2AccessToken.getValue());
    }

    private void processRepeatLogin(User user, HttpSession session) {
        String existSessionId = (String)this.redisTemplate.opsForValue().get((Object)(HAP_LOGIN_USER + user.getUserName()));
        this.redisTemplate.opsForValue().set((Object)(HAP_LOGIN_USER + user.getUserName()), (Object)session.getId(), (long)session.getMaxInactiveInterval(), TimeUnit.SECONDS);
        if (existSessionId != null && !existSessionId.equals(session.getId()) && this.sysConfigManager.isProhibitRepeatLogin()) {
            CommandMessage commandMessage = new CommandMessage();
            commandMessage.setSessionId(session.getId());
            commandMessage.setUserName(user.getUserName());
            commandMessage.setAction("SYS_REPEAT_LOGIN");
            this.iMessagePublisher.publish("webSocket", commandMessage);
        }
    }

    private void setProcessUser(User user, HttpSession session) {
        if (user.getEmployeeId() != null) {
            session.setAttribute("employeeId", (Object)user.getEmployeeId());
            session.setAttribute("employeeCode", (Object)user.getEmployeeCode());
            this.taskCreateNotificationListener.sendMessage(user);
            this.taskCreateNotificationListener.sendMessageForCC(user);
        }
    }

    private void setCompany(User user, HttpSession session) {
        Long companyId;
        if (user.getEmployeeId() != null && (companyId = this.employeeAssignService.getCompanyByEmployeeId(user.getEmployeeId())) != null) {
            session.setAttribute("companyId", (Object)companyId);
        }
    }

    private void setTimeZoneFromPreference(HttpServletRequest request, Long accountId) {
        String tz;
        SysPreferences pref = this.preferencesService.selectUserPreference("timeZone", accountId);
        String string = tz = pref == null ? null : pref.getPreferencesValue();
        if (StringUtils.isBlank((String)tz)) {
            String APP_SERVLET_CONTEXT_KEY = FrameworkServlet.SERVLET_CONTEXT_PREFIX + "appServlet";
            WebApplicationContext appContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext(), (String)APP_SERVLET_CONTEXT_KEY);
            TimeZone timeZone = ((SessionLocaleResolver)appContext.getBean(SessionLocaleResolver.class)).getDefaultTimeZone();
            tz = TimeZoneUtil.toGMTFormat(timeZone == null ? TimeZone.getDefault() : timeZone);
        }
        WebUtils.setSessionAttribute((HttpServletRequest)request, (String)SessionLocaleResolver.TIME_ZONE_SESSION_ATTRIBUTE_NAME, (Object)org.springframework.util.StringUtils.parseTimeZoneString((String)tz));
        request.getSession(true).setAttribute("timeZone", (Object)tz);
    }

    private void setNavFromPreference(HttpSession session, Long accountId) {
        SysPreferences pref = this.preferencesService.selectUserPreference("nav", accountId);
        String nav = pref == null ? null : pref.getPreferencesValue();
        session.setAttribute("nav", (Object)nav);
    }

    private void setLocalePreference(HttpServletRequest request, Long accountId) {
        SysPreferences pref = this.preferencesService.selectUserPreference("locale", accountId);
        if (pref != null) {
            WebUtils.setSessionAttribute((HttpServletRequest)request, (String)SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME, (Object)org.springframework.util.StringUtils.parseLocaleString((String)pref.getPreferencesValue()));
        }
    }

    private void setRoleInfo(HttpServletRequest request, HttpSession session, User user) {
        List<IRole> roles = this.roleService.selectActiveRolesByUser(RequestHelper.createServiceRequest(request), user);
        if (roles.isEmpty()) {
            request.setAttribute("code", (Object)"NO_ROLE");
            throw new RuntimeException(new RoleException(null, "error.account_no_role", null));
        }
        if (this.sysConfigManager.getRoleMergeFlag()) {
            ArrayList<Long> roleIds = new ArrayList<Long>();
            for (IRole role : roles) {
                roleIds.add(role.getRoleId());
            }
            Long[] ids = roleIds.toArray(new Long[roleIds.size()]);
            session.setAttribute("roleIds", (Object)ids);
            session.setAttribute("roleId", (Object)roles.get(0).getRoleId());
        }
    }

    private String generateSecurityKey(HttpSession session) {
        return TokenUtils.setSecurityKey(session);
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

