/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.service.impl;

import com.hand.hap.account.dto.User;
import com.hand.hap.account.exception.UserException;
import com.hand.hap.account.service.IRole;
import com.hand.hap.account.service.IRoleService;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.security.CustomUserDetails;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class CustomUserDetailsService
implements UserDetailsService {
    Logger logger = LoggerFactory.getLogger(CustomUserDetailsService.class);
    @Autowired
    private IUserService userService;
    @Autowired
    @Qualifier(value="roleServiceImpl")
    private IRoleService roleService;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        User user = this.userService.selectByUserName(username);
        if (user == null) {
            throw new UsernameNotFoundException("User not found:" + username);
        }
        this.checkUserException(user);
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("ROLE_USER"));
        List<IRole> roles = this.roleService.selectUserRolesByUserId(user.getUserId());
        for (IRole role : roles) {
            authorities.add(new SimpleGrantedAuthority(role.getRoleCode()));
        }
        CustomUserDetails userDetails = new CustomUserDetails(user.getUserId(), user.getUserName(), user.getPasswordEncrypted(), true, true, true, true, authorities);
        return userDetails;
    }

    private void checkUserException(User user) {
        UserException ue = null;
        if ("LOCK".equalsIgnoreCase(user.getStatus())) {
            ue = new UserException("error.user.account_locked", null);
        } else if ("EXPR".equalsIgnoreCase(user.getStatus())) {
            ue = new UserException("error.user.account_expired", null);
        } else if (user.getStartActiveDate() != null && user.getStartActiveDate().getTime() > System.currentTimeMillis()) {
            ue = new UserException("error.user.account_not_active", null);
        } else if (user.getEndActiveDate() != null && user.getEndActiveDate().getTime() < System.currentTimeMillis()) {
            ue = new UserException("error.user.account_expired", null);
        }
        if (ue != null) {
            throw new RuntimeException(ue);
        }
    }
}

