/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.permission.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.security.permission.dto.DataPermissionRuleAssign;
import com.hand.hap.security.permission.dto.DataPermissionRuleDetail;
import com.hand.hap.security.permission.mapper.DataPermissionRuleAssignMapper;
import com.hand.hap.security.permission.service.IDataPermissionRuleDetailService;
import com.hand.hap.system.dto.Lov;
import com.hand.hap.system.service.ILovService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class DataPermissionRuleDetailServiceImpl
extends BaseServiceImpl<DataPermissionRuleDetail>
implements IDataPermissionRuleDetailService {
    @Autowired
    private ILovService lovService;
    @Autowired
    DataPermissionRuleAssignMapper dataPermissionRuleAssignMapper;
    @Autowired
    IMessagePublisher iMessagePublisher;

    @Override
    public List<DataPermissionRuleDetail> selectRuleManageDetail(DataPermissionRuleDetail dto, int page, int pageSize, IRequest request) throws IllegalAccessException {
        List<DataPermissionRuleDetail> lists = this.select(request, dto, page, pageSize);
        if (null != dto.getPermissionField()) {
            Lov lov = new Lov();
            lov.setCode(dto.getPermissionField());
            List<Lov> lovs = this.lovService.selectLovs(request, lov, 1, 10);
            lov = lovs.get(0);
            String textField = lov.getTextField();
            String valueField = lov.getValueField();
            HashMap lovMap = new HashMap();
            List<?> list = this.lovService.selectDatas(request, dto.getPermissionField(), null, 0, 0);
            for (Object o : list) {
                if (o instanceof Map) {
                    DataPermissionRuleDetailServiceImpl.getValueByMap(textField, valueField, (Map)o, lovMap);
                    continue;
                }
                DataPermissionRuleDetailServiceImpl.getValueByBean(textField, valueField, o, lovMap);
            }
            for (DataPermissionRuleDetail list1 : lists) {
                list1.setPermissionFieldName((String)lovMap.get(list1.getPermissionFieldValue().toString()));
            }
        }
        return lists;
    }

    public static void getValueByBean(String textField, String valueField, Object object, Map lovMap) throws IllegalAccessException {
        Field[] fields;
        String text = null;
        String value = null;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            if (field.getName().equalsIgnoreCase(textField)) {
                field.setAccessible(true);
                text = field.get(object).toString();
                continue;
            }
            if (!field.getName().equalsIgnoreCase(valueField)) continue;
            field.setAccessible(true);
            value = field.get(object).toString();
        }
        lovMap.put(value, text);
    }

    public static void getValueByMap(String textField, String valueField, Map<String, String> object, Map lovMap) {
        lovMap.put(object.get(valueField), object.get(textField));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDataMaskRuleDetailWithAssign(List<DataPermissionRuleDetail> dataMaskRuleManageDetails) {
        this.batchDelete(dataMaskRuleManageDetails);
        dataMaskRuleManageDetails.forEach(v -> {
            DataPermissionRuleAssign assign = new DataPermissionRuleAssign();
            assign.setDetailId(v.getDetailId());
            this.dataPermissionRuleAssignMapper.delete(assign);
        });
    }

    @Override
    public List<DataPermissionRuleDetail> updateDataMaskRuleDetail(IRequest iRequest, List<DataPermissionRuleDetail> dto) {
        List<DataPermissionRuleDetail> dataMaskRuleManageDetails = ((IDataPermissionRuleDetailService)this.self()).batchUpdate(iRequest, dto);
        this.updateCache(dto.get(0).getRuleId());
        return dataMaskRuleManageDetails;
    }

    @Override
    public void removeDataMaskRuleDetail(List<DataPermissionRuleDetail> dataMaskRuleManageDetails) {
        ((IDataPermissionRuleDetailService)this.self()).removeDataMaskRuleDetailWithAssign(dataMaskRuleManageDetails);
        this.updateCache(dataMaskRuleManageDetails.get(0).getRuleId());
    }

    private void updateCache(Long ruleId) {
        this.iMessagePublisher.publish("dataPermission.ruleRefresh", ruleId);
    }
}

