/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.permission.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.security.permission.dto.DataPermissionRuleAssign;
import com.hand.hap.security.permission.service.IDataPermissionRuleAssignService;
import com.hand.hap.security.permission.service.impl.DataPermissionRuleDetailServiceImpl;
import com.hand.hap.system.dto.Lov;
import com.hand.hap.system.service.ILovService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class DataPermissionRuleAssignServiceImpl
extends BaseServiceImpl<DataPermissionRuleAssign>
implements IDataPermissionRuleAssignService {
    @Autowired
    private ILovService lovService;
    @Autowired
    IMessagePublisher iMessagePublisher;

    @Override
    public List<DataPermissionRuleAssign> selectRuleAssign(DataPermissionRuleAssign dto, int page, int pageSize, IRequest request) throws IllegalAccessException {
        List<DataPermissionRuleAssign> lists = this.select(request, dto, page, pageSize);
        for (DataPermissionRuleAssign dataMaskRuleAssign : lists) {
            Lov lov = new Lov();
            lov.setCode(dataMaskRuleAssign.getAssignField());
            List<Lov> lovs = this.lovService.selectLovs(request, lov, 1, 10);
            lov = lovs.get(0);
            String textField = lov.getTextField();
            String valueField = lov.getValueField();
            HashMap lovMap = new HashMap();
            List<?> list = this.lovService.selectDatas(request, dataMaskRuleAssign.getAssignField(), null, 0, 0);
            for (Object o : list) {
                if (o instanceof Map) {
                    DataPermissionRuleDetailServiceImpl.getValueByMap(textField, valueField, (Map)o, lovMap);
                    continue;
                }
                DataPermissionRuleDetailServiceImpl.getValueByBean(textField, valueField, o, lovMap);
            }
            dataMaskRuleAssign.setAssignFieldName((String)lovMap.get(dataMaskRuleAssign.getAssignFieldValue()));
        }
        return lists;
    }

    @Override
    public void removeDataMaskRuleAssign(List<DataPermissionRuleAssign> dataMaskRuleAssigns) {
        ((IDataPermissionRuleAssignService)this.self()).batchDelete(dataMaskRuleAssigns);
        this.updateCache(dataMaskRuleAssigns.get(0).getRuleId());
    }

    @Override
    public List<DataPermissionRuleAssign> updateDataMaskRuleAssign(IRequest request, List<DataPermissionRuleAssign> dataMaskRuleAssigns) {
        List<DataPermissionRuleAssign> dto = ((IDataPermissionRuleAssignService)this.self()).batchUpdate(request, dataMaskRuleAssigns);
        this.updateCache(dataMaskRuleAssigns.get(0).getRuleId());
        return dto;
    }

    private void updateCache(Long ruleId) {
        this.iMessagePublisher.publish("dataPermission.ruleRefresh", ruleId);
    }
}

