/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.permission.service.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.hand.hap.cache.Cache;
import com.hand.hap.cache.CacheManager;
import com.hand.hap.cache.impl.DataPermissionRuleCache;
import com.hand.hap.security.permission.dto.DataPermissionRule;
import com.hand.hap.security.permission.dto.DataPermissionRuleAssign;
import com.hand.hap.security.permission.dto.DataPermissionRuleDetail;
import com.hand.hap.security.permission.dto.DataPermissionTable;
import com.hand.hap.security.permission.dto.DataPermissionTableRule;
import com.hand.hap.security.permission.mapper.DataPermissionRuleAssignMapper;
import com.hand.hap.security.permission.mapper.DataPermissionRuleDetailMapper;
import com.hand.hap.security.permission.mapper.DataPermissionRuleMapper;
import com.hand.hap.security.permission.mapper.DataPermissionTableMapper;
import com.hand.hap.security.permission.mapper.DataPermissionTableRuleMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataPermissionCacheContainer {
    public final String CACHE_DELETE = "delete";
    public final String CACHE_UPDATE = "update";
    @Autowired
    DataPermissionTableMapper dataPermissionTableMapper;
    @Autowired
    DataPermissionTableRuleMapper dataPermissionTableRuleMapper;
    @Autowired
    DataPermissionRuleMapper dataPermissionRuleMapper;
    @Autowired
    DataPermissionRuleDetailMapper dataPermissionRuleDetailMapper;
    @Autowired
    DataPermissionRuleAssignMapper dataPermissionRuleAssignMapper;
    @Autowired
    private CacheManager cacheManager;
    private ConcurrentHashMap<String, List<DataPermissionTableRule>> maskTableRuleMaps = new ConcurrentHashMap();
    private LoadingCache<String, Map> maskRuleMaps;

    public void initContainer() {
        List<DataPermissionTable> dataMaskTables = this.dataPermissionTableMapper.selectAll();
        dataMaskTables.forEach(v -> {
            DataPermissionTableRule dataMaskTableRule = new DataPermissionTableRule();
            dataMaskTableRule.setTableId(v.getTableId());
            this.maskTableRuleMaps.put(v.getTableName().toUpperCase(), Optional.ofNullable(this.dataPermissionTableRuleMapper.select(dataMaskTableRule)).orElseGet(() -> new ArrayList()));
        });
        this.maskRuleMaps = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map>(){

            public Map load(String key) {
                return DataPermissionCacheContainer.this.loadDataMaskRule(key);
            }
        });
    }

    private Map loadDataMaskRule(String ruleCode) {
        Cache ruleCache = this.cacheManager.getCache("data_permission_rule");
        return (Map)Optional.ofNullable(ruleCache.getValue(ruleCode)).orElseGet(() -> new HashMap());
    }

    public void removeMaskTableRuleMap(String tableName) {
        this.maskTableRuleMaps.remove(tableName.toUpperCase());
    }

    public void updateMaskTableRuleMap(DataPermissionTableRule dataMaskTableRule, String action) {
        block5: {
            block4: {
                if (!StringUtils.equals((String)action, (String)"update")) break block4;
                List list = Optional.ofNullable(this.maskTableRuleMaps.get(dataMaskTableRule.getTableName().toUpperCase())).orElseGet(() -> {
                    ArrayList list1 = new ArrayList();
                    this.maskTableRuleMaps.put(dataMaskTableRule.getTableName().toUpperCase(), list1);
                    return list1;
                });
                boolean key = true;
                Iterator iterator = list.iterator();
                while (key) {
                    if (iterator.hasNext() && ((DataPermissionTableRule)iterator.next()).getTableRuleId().equals(dataMaskTableRule.getTableRuleId())) {
                        iterator.remove();
                        list.add(dataMaskTableRule);
                        key = false;
                        continue;
                    }
                    if (iterator.hasNext() || !key) continue;
                    list.add(dataMaskTableRule);
                    key = false;
                }
                break block5;
            }
            if (!StringUtils.equals((String)action, (String)"delete")) break block5;
            List<DataPermissionTableRule> list = this.maskTableRuleMaps.get(dataMaskTableRule.getTableName().toUpperCase());
            Iterator<DataPermissionTableRule> iterator = list.iterator();
            boolean key = true;
            while (key) {
                if (!iterator.hasNext()) {
                    key = false;
                    continue;
                }
                if (!iterator.hasNext() || !iterator.next().getTableRuleId().equals(dataMaskTableRule.getTableRuleId())) continue;
                iterator.remove();
                key = false;
            }
        }
    }

    public void removeMaskRuleMap(Long ruleId) {
        Cache ruleCache = this.cacheManager.getCache("data_permission_rule");
        ruleCache.remove(ruleId.toString());
        this.maskRuleMaps.invalidate((Object)ruleId.toString());
    }

    public void updateMaskRuleMap(Long ruleId) {
        DataPermissionRule man = new DataPermissionRule();
        man.setRuleId(ruleId);
        DataPermissionRule maskRuleManage = this.dataPermissionRuleMapper.select(man).get(0);
        HashMap<String, Map> ruleMaps = new HashMap<String, Map>();
        HashMap<String, DataPermissionRule> tempDataMaskRuleManage = new HashMap<String, DataPermissionRule>();
        HashMap<String, DataPermissionRuleDetail> tempDataMaskRuleManageDetail = new HashMap<String, DataPermissionRuleDetail>();
        HashMap<String, DataPermissionRuleAssign> tempDataMaskRuleAssign = new HashMap<String, DataPermissionRuleAssign>();
        tempDataMaskRuleManage.put(maskRuleManage.getRuleId().toString(), maskRuleManage);
        DataPermissionRuleDetail detail = new DataPermissionRuleDetail();
        detail.setRuleId(maskRuleManage.getRuleId());
        List<DataPermissionRuleDetail> detailTemp = this.dataPermissionRuleDetailMapper.select(detail);
        detailTemp.forEach(v -> {
            tempDataMaskRuleManageDetail.put(v.getDetailId().toString(), (DataPermissionRuleDetail)v);
            DataPermissionRuleAssign assign = new DataPermissionRuleAssign();
            assign.setDetailId(v.getDetailId());
            this.dataPermissionRuleAssignMapper.select(assign).forEach(u -> tempDataMaskRuleAssign.put(u.getAssignId().toString(), (DataPermissionRuleAssign)u));
        });
        Cache ruleCache = this.cacheManager.getCache("data_permission_rule");
        DataPermissionRuleCache cache = (DataPermissionRuleCache)ruleCache;
        cache.doCreateCacheMap(tempDataMaskRuleManage, tempDataMaskRuleManageDetail, tempDataMaskRuleAssign, ruleMaps);
        ruleMaps.forEach((k, v) -> cache.setValue((String)k, (Map)v));
        this.maskRuleMaps.refresh((Object)maskRuleManage.getRuleId().toString());
    }

    public List getTableRule(String tableName) {
        return Optional.ofNullable(this.maskTableRuleMaps.get(tableName.toUpperCase())).orElseGet(() -> new ArrayList());
    }

    public List getRuleDetailSet(String ruleId, String maskRange, String maskRangeValue) throws ExecutionException {
        List ruleAssign;
        Map ruleDetail;
        Map rules = (Map)this.maskRuleMaps.get((Object)ruleId);
        if (rules.containsKey(maskRange) && (ruleDetail = (Map)rules.get(maskRange)).containsKey(maskRangeValue) && (ruleAssign = (List)ruleDetail.get(maskRangeValue)).size() != 0) {
            return ruleAssign;
        }
        return new ArrayList();
    }

    public boolean notExistRules() {
        boolean rs = false;
        if (this.maskTableRuleMaps.size() == 0) {
            rs = true;
        }
        return rs;
    }
}

