/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.oauth.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.security.oauth.dto.Oauth2ClientDetails;
import com.hand.hap.security.oauth.service.IOauth2ClientDetailsService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/client/details"})
public class Oauth2ClientDetailsController
extends BaseController {
    @Autowired
    private IOauth2ClientDetailsService service;

    @RequestMapping(value={"/query"})
    @ResponseBody
    public ResponseData query(Oauth2ClientDetails dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.selectOptions(requestContext, dto, null, page, pageSize));
    }

    @RequestMapping(value={"/submit"})
    @ResponseBody
    public ResponseData update(HttpServletRequest request, @RequestBody List<Oauth2ClientDetails> dto, BindingResult result) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<Oauth2ClientDetails> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/updatePassword"})
    @ResponseBody
    public ResponseData updatePassword(HttpServletRequest request, Long id) {
        String pwd = this.service.updatePassword(id);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("clientSecret", pwd);
        return new ResponseData(Arrays.asList(result));
    }
}

