/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.session.Session;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.session.web.http.HttpSessionManager;
import org.springframework.session.web.http.MultiHttpSessionStrategy;
import org.springframework.util.Assert;

public class CustomCookieHttpSessionStrategy
implements MultiHttpSessionStrategy,
HttpSessionManager {
    private static final String DEFAULT_DELIMITER = " ";
    private static final String SESSION_IDS_WRITTEN_ATTR = CustomCookieHttpSessionStrategy.class.getName().concat(".SESSIONS_WRITTEN_ATTR");
    static final String DEFAULT_ALIAS = "0";
    static final String DEFAULT_SESSION_ALIAS_PARAM_NAME = "_s";
    private static final Pattern ALIAS_PATTERN = Pattern.compile("^[\\w-]{1,50}$");
    private String sessionParam = "_s";
    private CookieSerializer cookieSerializer = new DefaultCookieSerializer();
    private String deserializationDelimiter = " ";
    private String serializationDelimiter = " ";

    public String getRequestedSessionId(HttpServletRequest request) {
        Map<String, String> sessionIds = this.getSessionIds(request);
        String sessionAlias = this.getCurrentSessionAlias(request);
        return sessionIds.get(sessionAlias);
    }

    public String getCurrentSessionAlias(HttpServletRequest request) {
        if (this.sessionParam == null) {
            return DEFAULT_ALIAS;
        }
        String u = request.getParameter(this.sessionParam);
        return u == null ? DEFAULT_ALIAS : (!ALIAS_PATTERN.matcher(u).matches() ? DEFAULT_ALIAS : u);
    }

    public String getNewSessionAlias(HttpServletRequest request) {
        Set<String> sessionAliases = this.getSessionIds(request).keySet();
        if (sessionAliases.isEmpty()) {
            return DEFAULT_ALIAS;
        }
        long lastAlias = Long.decode(DEFAULT_ALIAS);
        for (String alias : sessionAliases) {
            long selectedAlias = this.safeParse(alias);
            if (selectedAlias <= lastAlias) continue;
            lastAlias = selectedAlias;
        }
        return Long.toHexString(lastAlias + 1L);
    }

    private long safeParse(String hex) {
        try {
            return Long.decode("0x" + hex);
        }
        catch (NumberFormatException var3) {
            return 0L;
        }
    }

    public void onNewSession(Session session, HttpServletRequest request, HttpServletResponse response) {
        Set<String> sessionIdsWritten = this.getSessionIdsWritten(request);
        if (!sessionIdsWritten.contains(session.getId())) {
            sessionIdsWritten.add(session.getId());
            Map<String, String> sessionIds = this.getSessionIds(request);
            String sessionAlias = this.getCurrentSessionAlias(request);
            sessionIds.put(sessionAlias, session.getId());
            String cookieValue = this.createSessionCookieValue(sessionIds);
            this.cookieSerializer.writeCookieValue(new CookieSerializer.CookieValue(request, response, cookieValue));
        }
    }

    private Set<String> getSessionIdsWritten(HttpServletRequest request) {
        HashSet sessionsWritten = (HashSet)request.getAttribute(SESSION_IDS_WRITTEN_ATTR);
        if (sessionsWritten == null) {
            sessionsWritten = new HashSet();
            request.setAttribute(SESSION_IDS_WRITTEN_ATTR, sessionsWritten);
        }
        return sessionsWritten;
    }

    private String createSessionCookieValue(Map<String, String> sessionIds) {
        if (sessionIds.isEmpty()) {
            return "";
        }
        if (sessionIds.size() == 1 && sessionIds.keySet().contains(DEFAULT_ALIAS)) {
            return sessionIds.values().iterator().next();
        }
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<String, String> entry : sessionIds.entrySet()) {
            String alias = entry.getKey();
            String id = entry.getValue();
            buffer.append(alias);
            buffer.append(this.serializationDelimiter);
            buffer.append(id);
            buffer.append(this.serializationDelimiter);
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public void onInvalidateSession(HttpServletRequest request, HttpServletResponse response) {
        Map<String, String> sessionIds = this.getSessionIds(request);
        String requestedAlias = this.getCurrentSessionAlias(request);
        sessionIds.remove(requestedAlias);
        String cookieValue = this.createSessionCookieValue(sessionIds);
        this.cookieSerializer.writeCookieValue(new CookieSerializer.CookieValue(request, response, cookieValue));
    }

    public void setSessionAliasParamName(String sessionAliasParamName) {
        this.sessionParam = sessionAliasParamName;
    }

    public void setCookieSerializer(CookieSerializer cookieSerializer) {
        Assert.notNull((Object)cookieSerializer, (String)"cookieSerializer cannot be null");
        this.cookieSerializer = cookieSerializer;
    }

    @Deprecated
    public void setCookieName(String cookieName) {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName(cookieName);
        this.cookieSerializer = serializer;
    }

    public void setDeserializationDelimiter(String delimiter) {
        this.deserializationDelimiter = delimiter;
    }

    public void setSerializationDelimiter(String delimiter) {
        this.serializationDelimiter = delimiter;
    }

    public Map<String, String> getSessionIds(HttpServletRequest request) {
        String sessionId;
        List cookieValues = this.cookieSerializer.readCookieValues(request);
        if (cookieValues.isEmpty() && null != (sessionId = request.getHeader("Authorization"))) {
            cookieValues.add(sessionId);
        }
        String sessionCookieValue = cookieValues.isEmpty() ? "" : (String)cookieValues.iterator().next();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        StringTokenizer tokens = new StringTokenizer(sessionCookieValue, this.deserializationDelimiter);
        if (tokens.countTokens() == 1) {
            result.put(DEFAULT_ALIAS, tokens.nextToken());
            return result;
        }
        while (tokens.hasMoreTokens()) {
            String alias = tokens.nextToken();
            if (!tokens.hasMoreTokens()) break;
            String id = tokens.nextToken();
            result.put(alias, id);
        }
        return result;
    }

    public HttpServletRequest wrapRequest(HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(HttpSessionManager.class.getName(), (Object)this);
        return request;
    }

    public HttpServletResponse wrapResponse(HttpServletRequest request, HttpServletResponse response) {
        return new MultiSessionHttpServletResponse(response, request);
    }

    public String encodeURL(String url, String sessionAlias) {
        String encodedSessionAlias = this.urlEncode(sessionAlias);
        int queryStart = url.indexOf("?");
        boolean isDefaultAlias = DEFAULT_ALIAS.equals(encodedSessionAlias);
        if (queryStart < 0) {
            return isDefaultAlias ? url : url + "?" + this.sessionParam + "=" + encodedSessionAlias;
        }
        String path = url.substring(0, queryStart);
        String query = url.substring(queryStart + 1, url.length());
        String replacement = isDefaultAlias ? "" : "$1" + encodedSessionAlias;
        query = query.replaceFirst("((^|&)" + this.sessionParam + "=)([^&]+)?", replacement);
        if (!isDefaultAlias && url.endsWith(query)) {
            if (!query.endsWith("&") && query.length() != 0) {
                query = query + "&";
            }
            query = query + this.sessionParam + "=" + encodedSessionAlias;
        }
        return path + "?" + query;
    }

    private String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException var3) {
            throw new RuntimeException(var3);
        }
    }

    class MultiSessionHttpServletResponse
    extends HttpServletResponseWrapper {
        private final HttpServletRequest request;

        MultiSessionHttpServletResponse(HttpServletResponse response, HttpServletRequest request) {
            super(response);
            this.request = request;
        }

        public String encodeRedirectURL(String url) {
            url = super.encodeRedirectURL(url);
            return CustomCookieHttpSessionStrategy.this.encodeURL(url, CustomCookieHttpSessionStrategy.this.getCurrentSessionAlias(this.request));
        }

        public String encodeURL(String url) {
            url = super.encodeURL(url);
            String alias = CustomCookieHttpSessionStrategy.this.getCurrentSessionAlias(this.request);
            return CustomCookieHttpSessionStrategy.this.encodeURL(url, alias);
        }
    }
}

