/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.report.controllers;

import com.hand.hap.cache.impl.LovCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.report.dto.Report;
import com.hand.hap.report.dto.ReportFiles;
import com.hand.hap.report.service.IReportFilesService;
import com.hand.hap.report.service.IReportService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.Lov;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.ILovService;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/report", "/api/sys/report"})
public class ReportController
extends BaseController {
    @Autowired
    private IReportService reportService;
    @Autowired
    private ILovService commonLovService;
    @Autowired
    private IReportFilesService reportFilesService;
    @Autowired
    private LovCache lovCache;

    @RequestMapping(value={"/getLov"})
    @ResponseBody
    public ResponseData getLov(HttpServletRequest request, @RequestParam(required=false) String sourceCode) {
        IRequest requestContext = this.createRequestContext(request);
        JSONArray lovData = new JSONArray();
        Lov lov = this.lovCache.getValue(sourceCode);
        if (null != lov) {
            String textField = lov.getTextField();
            String valueField = lov.getValueField();
            if (null != lov.getCustomUrl() && !lov.getCustomUrl().equals("")) {
                Cookie[] cookies = request.getCookies();
                StringBuilder sb = new StringBuilder();
                for (Cookie cookie : cookies) {
                    sb.append(cookie.getName() + "=" + cookie.getValue() + ";");
                }
                String cookieValue = sb.toString();
                CloseableHttpClient httpclient = HttpClients.createDefault();
                String path = request.getContextPath();
                String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
                HttpGet httpget = new HttpGet(basePath + lov.getCustomUrl());
                httpget.addHeader((Header)new BasicHeader("Cookie", cookieValue));
                try {
                    CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);
                    HttpEntity entity = response.getEntity();
                    JSONObject jsonObject = JSONObject.fromObject((Object)EntityUtils.toString((HttpEntity)entity));
                    String rows = String.valueOf(jsonObject.get("rows"));
                    lovData = JSONArray.fromObject((Object)rows);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                List<?> data = this.commonLovService.selectDatas(requestContext, sourceCode, null, 1, 0);
                if (CollectionUtils.isNotEmpty(data) && data.get(0) instanceof HashMap) {
                    for (int index = 0; index < data.size(); ++index) {
                        Map map = (Map)data.get(index);
                        map.put("valueField", map.get(valueField));
                        map.put("textField", map.get(textField));
                    }
                    return new ResponseData(data);
                }
                lovData = JSONArray.fromObject(data);
            }
            for (int i = 0; i < lovData.size(); ++i) {
                JSONObject jsonObject = (JSONObject)lovData.get(i);
                jsonObject.put((Object)"valueField", jsonObject.get(valueField));
                jsonObject.put((Object)"textField", jsonObject.get(textField));
                this.initAttribute(jsonObject);
            }
            return new ResponseData((List<?>)lovData);
        }
        return new ResponseData();
    }

    private void initAttribute(JSONObject jsonObject) {
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = jsonObject.get(key);
            if (!value.equals("null") && !value.equals(null)) continue;
            jsonObject.replace((Object)key, (Object)"");
        }
    }

    @RequestMapping(value={"/query"})
    @ResponseBody
    public ResponseData query(HttpServletRequest request, Report report, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.reportService.selectOptions(requestContext, report, null, page, pageSize));
    }

    @RequestMapping(value={"/queryByCode"})
    @ResponseBody
    public ResponseData queryByCode(HttpServletRequest request, @RequestParam(required=false) String reportCode) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.reportService.selectByReportCode(reportCode));
    }

    @RequestMapping(value={"/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<Report> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.reportService.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<Report> dto) {
        this.reportService.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/queryReportFileParams"})
    @ResponseBody
    public ResponseData queryReportFileParams(HttpServletRequest request, @RequestParam(required=false) String reportCode) {
        ReportFiles reportFiles = this.reportFilesService.selectReportFileParams(reportCode);
        String[] params = new String[]{};
        if (reportFiles != null && reportFiles.getParams() != null && reportFiles.getParams() != "") {
            params = StringUtils.split((String)reportFiles.getParams(), (String)";");
        }
        return new ResponseData(Arrays.asList(params));
    }
}

