/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mybatis.common;

import com.hand.hap.mybatis.common.query.SQLField;
import com.hand.hap.mybatis.common.query.Selection;
import com.hand.hap.mybatis.common.query.SortField;
import com.hand.hap.mybatis.common.query.SortType;
import com.hand.hap.mybatis.common.query.WhereField;
import com.hand.hap.system.dto.BaseDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Criteria {
    private List<Selection> selectFields;
    private List<SortField> sortFields;
    private List<WhereField> whereFields;
    private List<String> excludeSelectFields;
    private List<String> updateFields;

    public Criteria() {
    }

    public Criteria(Object obj) {
        BaseDTO dto;
        if (obj instanceof BaseDTO && (dto = (BaseDTO)obj) != null && dto.getSortname() != null) {
            this.sort(dto.getSortname(), dto.getSortorder() != null ? SortType.valueOf(dto.getSortorder().toUpperCase()) : SortType.ASC);
        }
    }

    public Criteria sort(String field, SortType sortType) {
        if (this.sortFields == null) {
            this.sortFields = new ArrayList<SortField>();
        }
        if (!this.containField(this.sortFields, field)) {
            this.sortFields.add(new SortField(field, sortType));
        }
        return this;
    }

    public Criteria select(String ... fields) {
        this.excludeSelectFields = null;
        if (this.selectFields == null) {
            this.selectFields = new ArrayList<Selection>(50);
        }
        if (fields.length > 0 && !this.selectFields.contains("objectVersionNumber")) {
            this.selectFields.add(new Selection("objectVersionNumber"));
        }
        for (String field : fields) {
            if (this.containField(this.selectFields, field)) continue;
            this.selectFields.add(new Selection(field));
        }
        return this;
    }

    public Criteria unSelect(String ... fields) {
        this.selectFields = null;
        if (this.excludeSelectFields == null) {
            this.excludeSelectFields = new ArrayList<String>(50);
        }
        for (String field : fields) {
            if (this.excludeSelectFields.contains(field)) continue;
            this.excludeSelectFields.add(field);
        }
        return this;
    }

    public Criteria where(Object ... fields) {
        for (Object field : fields) {
            if (field instanceof WhereField) {
                this.where((WhereField)field);
                continue;
            }
            if (!(field instanceof String)) continue;
            this.where((String)field);
        }
        return this;
    }

    public Criteria where(WhereField ... fields) {
        if (this.whereFields == null) {
            this.whereFields = new ArrayList<WhereField>(15);
        }
        for (WhereField field : fields) {
            if (this.whereFields.contains(field)) continue;
            this.whereFields.add(field);
        }
        return this;
    }

    public Criteria where(String ... fields) {
        if (this.whereFields == null) {
            this.whereFields = new ArrayList<WhereField>(15);
        }
        for (String field : fields) {
            if (this.whereFields.contains(field)) continue;
            this.whereFields.add(new WhereField(field));
        }
        return this;
    }

    private boolean containField(List<? extends SQLField> list, String field) {
        boolean found = false;
        for (SQLField sQLField : list) {
            if (!sQLField.getField().equals(field)) continue;
            found = true;
            break;
        }
        return found;
    }

    public void update(String ... fields) {
        if (this.updateFields == null) {
            this.updateFields = new ArrayList<String>(50);
        }
        if (fields.length > 0 && !this.updateFields.contains("lastUpdateDate")) {
            this.updateFields.addAll(Arrays.asList("lastUpdateDate", "lastUpdatedBy", "lastUpdateLogin"));
        }
        for (String field : fields) {
            if (this.updateFields.contains(field)) continue;
            this.updateFields.add(field);
        }
    }

    public List<String> getUpdateFields() {
        return this.updateFields;
    }

    public List<Selection> getSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(List<Selection> selectFields) {
        this.selectFields = selectFields;
    }

    public List<SortField> getSortFields() {
        return this.sortFields;
    }

    public void setSortFields(List<SortField> sortFields) {
        this.sortFields = sortFields;
    }

    public List<WhereField> getWhereFields() {
        return this.whereFields;
    }

    public void setWhereFields(List<WhereField> whereFields) {
        this.whereFields = whereFields;
    }

    public List<String> getExcludeSelectFields() {
        return this.excludeSelectFields;
    }

    public void setExcludeSelectFields(List<String> excludeSelectFields) {
        this.excludeSelectFields = excludeSelectFields;
    }
}

