/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.impl;

import com.hand.hap.message.IQueueMessageListener;
import com.hand.hap.message.ITopicMessageListener;
import com.hand.hap.message.MethodReflectUtils;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;

public class MessageListenerAdaptor<T>
implements ITopicMessageListener<T>,
IQueueMessageListener<T>,
BeanNameAware,
InitializingBean {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private Object delegate;
    private String methodName = "onMessage";
    private Method method;
    private RedisSerializer<T> redisSerializer;

    @Override
    public String getQueue() {
        return this.name;
    }

    @Override
    public void onQueueMessage(T message, String queue) {
        this.onTopicMessage(message, queue);
    }

    @Override
    public String[] getTopic() {
        return new String[]{this.name};
    }

    @Override
    public RedisSerializer<T> getRedisSerializer() {
        return this.redisSerializer;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onTopicMessage(T message, String pattern) {
        block3: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("receive message: {}, from: {}", message, (Object)this.name);
            }
            try {
                this.method.invoke(this.delegate, message, pattern);
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.error("error while invoke method:" + this.methodName, (Throwable)e);
            }
        }
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.delegate, (String)"delegate can not be null.");
        Assert.notNull((Object)this.methodName, (String)"methodName can not be null.");
        List<Method> methods = MethodReflectUtils.findMethod(this.delegate.getClass(), new MethodReflectUtils.FindDesc(this.methodName, 2));
        if (methods.size() == 0) {
            throw new RuntimeException("No suitable method named '" + this.methodName + "' found in " + this.delegate);
        }
        if (methods.size() != 1) {
            throw new RuntimeException("'" + this.methodName + "' has OVERLOAD method.");
        }
        this.method = methods.get(0);
        Class<?> type = this.method.getParameterTypes()[0];
        this.redisSerializer = MethodReflectUtils.getProperRedisSerializer(type);
    }
}

