/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.components;

import com.hand.hap.intergration.InvokeLogStrategy;
import com.hand.hap.intergration.beans.HapinterfaceBound;
import com.hand.hap.intergration.components.DefaultInvokeLogStrategy;
import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.TopicMonitor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
@TopicMonitor(channel={"invoke.inbound", "invoke.outbound"})
public class InvokeLogManager
implements IMessageConsumer<HapinterfaceBound>,
InitializingBean {
    public static final String CHANNEL_OUTBOUND = "invoke.outbound";
    public static final String CHANNEL_INBOUND = "invoke.inbound";
    @Autowired(required=false)
    private InvokeLogStrategy invokeLogStrategy;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public void onMessage(HapinterfaceBound message, String pattern) {
        if (CHANNEL_INBOUND.equalsIgnoreCase(pattern)) {
            this.invokeLogStrategy.logInbound(message.getInbound());
        } else if (CHANNEL_OUTBOUND.equalsIgnoreCase(pattern)) {
            this.invokeLogStrategy.logOutbound(message.getOutbound());
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.invokeLogStrategy == null) {
            this.invokeLogStrategy = new DefaultInvokeLogStrategy();
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)this.invokeLogStrategy);
        }
    }

    public InvokeLogStrategy getInvokeLogStrategy() {
        return this.invokeLogStrategy;
    }
}

