/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.components;

import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.TopicMonitor;
import com.hand.hap.system.dto.Prompt;
import com.hand.hap.system.mapper.PromptMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@TopicMonitor(channel={"cache.prompt"})
public class DefaultPromptListener
implements IMessageConsumer<String>,
InitializingBean {
    @Autowired
    private PromptMapper promptMapper;
    private Map<String, List<Prompt>> promptsMap = new HashMap<String, List<Prompt>>();

    @Override
    public void onMessage(String message, String pattern) {
        if (message.toLowerCase().startsWith("hap.")) {
            this.reload();
        }
    }

    private void reload() {
        Prompt p = new Prompt();
        p.setPromptCode("hap.");
        List<Prompt> prompts = this.promptMapper.select(p);
        HashMap<String, List<Prompt>> promptsMapNew = new HashMap<String, List<Prompt>>();
        for (Prompt prompt : prompts) {
            ArrayList<Prompt> list = (ArrayList<Prompt>)promptsMapNew.get(prompt.getLang());
            if (list == null) {
                list = new ArrayList<Prompt>();
                promptsMapNew.put(prompt.getLang(), list);
            }
            list.add(prompt);
        }
        this.promptsMap = promptsMapNew;
    }

    public List<Prompt> getDefaultPrompt(String lang) {
        return this.promptsMap.get(lang);
    }

    public void afterPropertiesSet() throws Exception {
        this.reload();
    }
}

