/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mail.service.impl;

import com.hand.hap.mail.dto.Message;
import com.hand.hap.mail.service.IEmailService;
import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.QueueMonitor;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@QueueMonitor(queue="hap:queue:email:vip")
public class VipMessageReceiver
implements IMessageConsumer<Message> {
    @Autowired
    IEmailService emailService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void onMessage(Message message, String pattern) {
        HashedMap params = new HashedMap();
        params.put("batch", 0);
        params.put("isVipQueue", true);
        try {
            this.emailService.sendMessageByReceiver(message, (Map<String, Object>)params);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

