/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mail.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.mail.dto.MessageAccount;
import com.hand.hap.mail.mapper.MessageAccountMapper;
import com.hand.hap.mail.service.IMessageAccountService;
import com.hand.hap.security.service.IAESClientService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service
public class MessageAccountServiceImpl
extends BaseServiceImpl<MessageAccount>
implements IMessageAccountService,
BeanFactoryAware {
    private BeanFactory beanFactory;
    @Autowired
    private MessageAccountMapper accountMapper;
    @Autowired
    private IAESClientService aceClientService;

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public MessageAccount createMessageAccount(IRequest request, MessageAccount obj) {
        if (obj == null) {
            return null;
        }
        obj.setPassword(this.aceClientService.encrypt(obj.getPassword()));
        this.accountMapper.insertSelective(obj);
        return obj;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public MessageAccount updateMessageAccount(IRequest request, MessageAccount obj) {
        if (obj == null) {
            return null;
        }
        obj.setPassword(null);
        int updateCount = this.accountMapper.updateByPrimaryKeySelective(obj);
        this.checkOvn(updateCount, obj);
        return obj;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public MessageAccount updateMessageAccountPasswordOnly(IRequest request, MessageAccount obj) {
        if (obj == null) {
            return null;
        }
        obj.setPassword(this.aceClientService.encrypt(obj.getPassword()));
        int updateCount = this.accountMapper.updateByPrimaryKeySelective(obj);
        this.checkOvn(updateCount, obj);
        return obj;
    }

    @Override
    public MessageAccount selectMessageAccountById(IRequest request, Long objId) {
        if (objId == null) {
            return null;
        }
        return (MessageAccount)this.accountMapper.selectByPrimaryKey(new BigDecimal(objId));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int deleteMessageAccount(IRequest request, MessageAccount obj) {
        if (obj.getAccountId() == null) {
            return 0;
        }
        int updateCount = this.accountMapper.deleteByPrimaryKey(obj);
        this.checkOvn(updateCount, obj);
        return updateCount;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int batchDelete(IRequest request, List<MessageAccount> objs) {
        int result = 0;
        if (objs == null || objs.isEmpty()) {
            return result;
        }
        for (MessageAccount obj : objs) {
            ((IMessageAccountService)this.self()).deleteMessageAccount(request, obj);
            ++result;
        }
        return result;
    }

    @Override
    public List<MessageAccount> selectMessageAccounts(IRequest request, MessageAccount example, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        List<MessageAccount> list = this.accountMapper.select(example);
        return list;
    }

    @Override
    public List<MessageAccount> selectMessageAccountPassword(IRequest request, MessageAccount example, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        List<MessageAccount> list = this.accountMapper.selectMessageAccountPassword(example);
        return list;
    }
}

