/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mail.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.mail.dto.MessageAccount;
import com.hand.hap.mail.service.IMessageAccountService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/messageAccount", "/api/sys/messageAccount"})
public class MessageAccountController
extends BaseController {
    @Autowired
    private IMessageAccountService service;

    @RequestMapping(value={"/query"})
    @ResponseBody
    public ResponseData getMessageAccount(HttpServletRequest request, MessageAccount example, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.selectMessageAccounts(requestContext, example, page, pagesize));
    }

    @RequestMapping(value={"/queryAccount"})
    @ResponseBody
    public ResponseData getMessageAccountPassword(HttpServletRequest request, MessageAccount example) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.selectMessageAccountPassword(requestContext, example, 1, 1));
    }

    @ResponseBody
    @RequestMapping(value={"/add"})
    public ResponseData addMessageAccount(HttpServletRequest request, @RequestBody MessageAccount obj, BindingResult result) throws BaseException {
        obj.setObjectVersionNumber(0L);
        this.getValidator().validate((Object)obj, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestContext = this.createRequestContext(request);
        this.service.createMessageAccount(requestContext, obj);
        return new ResponseData();
    }

    @ResponseBody
    @RequestMapping(value={"/update"})
    public ResponseData updateMessageAccount(HttpServletRequest request, @RequestBody MessageAccount obj, BindingResult result) throws BaseException {
        obj.setObjectVersionNumber(0L);
        this.getValidator().validate((Object)obj, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestContext = this.createRequestContext(request);
        this.service.updateMessageAccount(requestContext, obj);
        return new ResponseData();
    }

    @ResponseBody
    @RequestMapping(value={"/updatePasswordOnly"})
    public ResponseData updateMessageAccountPasswordOnly(HttpServletRequest request, @RequestBody MessageAccount obj, BindingResult result) throws BaseException {
        obj.setObjectVersionNumber(0L);
        this.getValidator().validate((Object)obj, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestContext = this.createRequestContext(request);
        this.service.updateMessageAccountPasswordOnly(requestContext, obj);
        return new ResponseData();
    }

    @RequestMapping(value={"/remove"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData deleteMessageAccount(HttpServletRequest request, @RequestBody List<MessageAccount> objs) throws BaseException {
        IRequest requestContext = this.createRequestContext(request);
        this.service.batchDelete(requestContext, objs);
        return new ResponseData();
    }
}

