/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.job.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.FieldRequiredException;
import com.hand.hap.job.AbstractJob;
import com.hand.hap.job.dto.CronTriggerDto;
import com.hand.hap.job.dto.JobCreateDto;
import com.hand.hap.job.dto.JobData;
import com.hand.hap.job.dto.JobDetailDto;
import com.hand.hap.job.dto.JobInfoDetailDto;
import com.hand.hap.job.dto.SchedulerDto;
import com.hand.hap.job.dto.SimpleTriggerDto;
import com.hand.hap.job.dto.TriggerDto;
import com.hand.hap.job.exception.JobException;
import com.hand.hap.job.mapper.CronTriggerMapper;
import com.hand.hap.job.mapper.JobDetailMapper;
import com.hand.hap.job.mapper.SchedulerMapper;
import com.hand.hap.job.mapper.SimpleTriggerMapper;
import com.hand.hap.job.mapper.TriggerMapper;
import com.hand.hap.job.service.IQuartzService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuartzServiceImpl
implements IQuartzService {
    private final Logger logger = LoggerFactory.getLogger(QuartzServiceImpl.class);
    @Autowired
    private JobDetailMapper jobDetailMapper;
    @Autowired
    private TriggerMapper triggerMapper;
    @Autowired
    private CronTriggerMapper cronTriggerMapper;
    @Autowired
    private SimpleTriggerMapper simpleTriggerMapper;
    @Autowired
    private SchedulerMapper schedulerMapper;
    @Autowired
    private Scheduler quartzScheduler;

    @Override
    public List<TriggerDto> getTriggers(IRequest request, TriggerDto example, int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        return this.triggerMapper.selectTriggers(example);
    }

    @Override
    public CronTriggerDto getCronTrigger(String triggerName, String triggerGroup) throws SchedulerException {
        CronTriggerDto dto = new CronTriggerDto();
        dto.setSchedName(this.quartzScheduler.getSchedulerName());
        dto.setTriggerName(triggerName);
        dto.setTriggerGroup(triggerGroup);
        return this.cronTriggerMapper.selectByPrimaryKey(dto);
    }

    @Override
    public SimpleTriggerDto getSimpleTrigger(String triggerName, String triggerGroup) throws SchedulerException {
        SimpleTriggerDto dto = new SimpleTriggerDto();
        dto.setSchedName(this.quartzScheduler.getSchedulerName());
        dto.setTriggerName(triggerName);
        dto.setTriggerGroup(triggerGroup);
        return this.simpleTriggerMapper.selectByPrimaryKey(dto);
    }

    @Override
    public List<JobInfoDetailDto> getJobInfoDetails(IRequest request, JobDetailDto example, int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        List<JobInfoDetailDto> selectJobInfoDetails = this.jobDetailMapper.selectJobInfoDetails(example);
        for (JobInfoDetailDto jobInfoDetailDto : selectJobInfoDetails) {
            try {
                JobKey jobKey = new JobKey(jobInfoDetailDto.getJobName(), jobInfoDetailDto.getJobGroup());
                JobDetail jobDetail = this.quartzScheduler.getJobDetail(jobKey);
                JobDataMap jobDataMap = jobDetail.getJobDataMap();
                String[] keys = jobDataMap.getKeys();
                ArrayList<JobData> jobDatas = new ArrayList<JobData>();
                for (String string : keys) {
                    JobData e = new JobData();
                    e.setName(string);
                    e.setValue(jobDataMap.getString(string));
                    jobDatas.add(e);
                }
                List triggers = this.quartzScheduler.getTriggersOfJob(jobKey);
                if (triggers == null || triggers.isEmpty()) {
                    this.logger.error("job.error.has_no_trigger--" + jobKey.getGroup() + "." + jobKey.getName());
                    continue;
                }
                Trigger trigger = (Trigger)triggers.get(0);
                if (trigger instanceof SimpleTrigger) {
                    jobInfoDetailDto.setTriggerType("SIMPLE");
                    jobInfoDetailDto.setRepeatCount(((SimpleTrigger)trigger).getRepeatCount());
                    jobInfoDetailDto.setRepeatInterval(((SimpleTrigger)trigger).getRepeatInterval());
                } else if (trigger instanceof CronTrigger) {
                    jobInfoDetailDto.setCronExpression(((CronTrigger)trigger).getCronExpression());
                    jobInfoDetailDto.setTriggerType("CRON");
                }
                jobInfoDetailDto.setTriggerName(trigger.getKey().getName());
                jobInfoDetailDto.setTriggerGroup(trigger.getKey().getGroup());
                jobInfoDetailDto.setStartTime(trigger.getStartTime());
                jobInfoDetailDto.setPreviousFireTime(trigger.getPreviousFireTime());
                jobInfoDetailDto.setNextFireTime(trigger.getNextFireTime());
                jobInfoDetailDto.setEndTime(trigger.getEndTime());
                jobInfoDetailDto.setJobDatas(jobDatas);
                Trigger.TriggerState ts = this.quartzScheduler.getTriggerState(trigger.getKey());
                jobInfoDetailDto.setRunningState(ts.name());
            }
            catch (SchedulerException e) {
                jobInfoDetailDto.setRunningState(Trigger.TriggerState.ERROR.name());
                if (!this.logger.isErrorEnabled()) continue;
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return selectJobInfoDetails;
    }

    @Override
    public List<JobDetailDto> getJobDetails(IRequest request, JobDetailDto example, int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        return this.jobDetailMapper.selectJobDetails(example);
    }

    @Override
    public Map<String, Object> schedulerInformation() throws SchedulerException {
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        SchedulerMetaData metaData = this.quartzScheduler.getMetaData();
        if (metaData.getRunningSince() != null) {
            infoMap.put("runningSince", metaData.getRunningSince().getTime());
        }
        infoMap.put("numberOfJobsExecuted", metaData.getNumberOfJobsExecuted());
        infoMap.put("schedulerName", metaData.getSchedulerName());
        infoMap.put("schedulerInstanceId", metaData.getSchedulerInstanceId());
        infoMap.put("threadPoolSize", metaData.getThreadPoolSize());
        infoMap.put("version", metaData.getVersion());
        infoMap.put("inStandbyMode", metaData.isInStandbyMode());
        infoMap.put("jobStoreClustered", metaData.isJobStoreClustered());
        infoMap.put("jobStoreClass", metaData.getJobStoreClass());
        infoMap.put("jobStoreSupportsPersistence", metaData.isJobStoreSupportsPersistence());
        infoMap.put("started", metaData.isStarted());
        infoMap.put("shutdown", metaData.isShutdown());
        infoMap.put("schedulerRemote", metaData.isSchedulerRemote());
        return infoMap;
    }

    @Override
    public List<SchedulerDto> selectSchedulers(SchedulerDto schedulerDto, int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        return this.schedulerMapper.selectSchedulers(schedulerDto);
    }

    @Override
    public void createJob(JobCreateDto jobCreateDto) throws ClassNotFoundException, SchedulerException, JobException {
        Class<?> forName;
        boolean assignableFrom;
        String jobClassName;
        block20: {
            if (org.springframework.util.StringUtils.isEmpty((Object)jobCreateDto.getJobClassName())) {
                throw new RuntimeException(new FieldRequiredException("hap.validation.notempty", new Object[]{"jobClassName"}));
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)jobCreateDto.getJobName())) {
                throw new RuntimeException(new FieldRequiredException("hap.validation.notempty", new Object[]{"jobName"}));
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)jobCreateDto.getJobGroup())) {
                throw new RuntimeException(new FieldRequiredException("hap.validation.notempty", new Object[]{"jobGroup"}));
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)jobCreateDto.getTriggerName())) {
                throw new RuntimeException(new FieldRequiredException("hap.validation.notempty", new Object[]{"triggerName"}));
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)jobCreateDto.getTriggerGroup())) {
                throw new RuntimeException(new FieldRequiredException("hap.validation.notempty", new Object[]{"triggerGroup"}));
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)jobCreateDto.getTriggerType())) {
                throw new RuntimeException(new FieldRequiredException("hap.validation.notempty", new Object[]{"triggerType"}));
            }
            jobClassName = jobCreateDto.getJobClassName();
            assignableFrom = false;
            forName = null;
            try {
                forName = Class.forName(jobClassName);
                assignableFrom = AbstractJob.class.isAssignableFrom(forName);
            }
            catch (ClassNotFoundException e) {
                if (!this.logger.isErrorEnabled()) break block20;
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (!assignableFrom || forName == null) {
            String name = AbstractJob.class.getName();
            throw new JobException("JOB_EXCEPTION", "job.error.invalid_job_class", new Object[]{jobClassName, name});
        }
        JobBuilder jb = JobBuilder.newJob(forName).withIdentity(jobCreateDto.getJobName(), jobCreateDto.getJobGroup()).withDescription(jobCreateDto.getDescription()).requestRecovery().storeDurably();
        if (this.hasJobData(jobCreateDto)) {
            JobDataMap data = new JobDataMap();
            List<JobData> jobDatas = jobCreateDto.getJobDatas();
            for (JobData jobData : jobDatas) {
                data.put(jobData.getName(), jobData.getValue());
            }
            jb = jb.usingJobData(data);
        }
        JobDetail jobDetail = jb.build();
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(jobCreateDto.getTriggerName(), jobCreateDto.getTriggerGroup()).forJob(jobDetail);
        if (jobCreateDto.getStartTime() != null && jobCreateDto.getStartTime() > 0L) {
            triggerBuilder.startAt(new Date(jobCreateDto.getStartTime()));
        }
        if (jobCreateDto.getEndTime() != null && jobCreateDto.getEndTime() > 0L) {
            triggerBuilder.endAt(new Date(jobCreateDto.getEndTime()));
        }
        CronScheduleBuilder sche = null;
        if ("CRON".equalsIgnoreCase(jobCreateDto.getTriggerType())) {
            if (StringUtils.isEmpty((String)jobCreateDto.getCronExpression())) {
                throw new RuntimeException(new FieldRequiredException("hap.validation.notempty", new Object[]{"cronExpression"}));
            }
            sche = CronScheduleBuilder.cronSchedule((String)jobCreateDto.getCronExpression());
        } else if ("SIMPLE".equalsIgnoreCase(jobCreateDto.getTriggerType())) {
            if (org.springframework.util.StringUtils.isEmpty((Object)jobCreateDto.getRepeatInterval())) {
                throw new RuntimeException(new FieldRequiredException("hap.validation.notempty", new Object[]{"repeatInterval"}));
            }
            int interval = Integer.parseInt(jobCreateDto.getRepeatInterval());
            int count = 0;
            try {
                count = Integer.parseInt(jobCreateDto.getRepeatCount());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sche = count < 1 ? SimpleScheduleBuilder.repeatSecondlyForever((int)interval) : SimpleScheduleBuilder.repeatSecondlyForTotalCount((int)count, (int)interval);
        }
        Trigger trigger = triggerBuilder.withSchedule((ScheduleBuilder)sche).build();
        this.quartzScheduler.scheduleJob(jobDetail, trigger);
    }

    private boolean hasJobData(JobCreateDto jobCreateDto) {
        List<JobData> jobDatas = jobCreateDto.getJobDatas();
        return jobDatas != null && !jobDatas.isEmpty();
    }

    @Override
    public void deleteJob(String jobName, String jobGroup) throws SchedulerException {
        this.quartzScheduler.deleteJob(new JobKey(jobName, jobGroup));
    }

    @Override
    public Map<String, Object> start() throws SchedulerException {
        this.quartzScheduler.start();
        return this.schedulerInformation();
    }

    @Override
    public Map<String, Object> standby() throws SchedulerException {
        this.quartzScheduler.standby();
        return this.schedulerInformation();
    }

    @Override
    public Map<String, Object> pauseAll() throws SchedulerException {
        this.quartzScheduler.pauseAll();
        return this.schedulerInformation();
    }

    @Override
    public Map<String, Object> resumeAll() throws SchedulerException {
        this.quartzScheduler.resumeAll();
        return this.schedulerInformation();
    }

    @Override
    public void pauseJobs(List<JobDetailDto> list) throws SchedulerException {
        for (JobDetailDto job : list) {
            this.quartzScheduler.pauseJob(JobKey.jobKey((String)job.getJobName(), (String)job.getJobGroup()));
        }
    }

    @Override
    public void resumeJobs(List<JobDetailDto> list) throws SchedulerException {
        for (JobDetailDto job : list) {
            this.quartzScheduler.resumeJob(JobKey.jobKey((String)job.getJobName(), (String)job.getJobGroup()));
        }
    }

    @Override
    public void deleteJobs(List<JobDetailDto> list) throws SchedulerException {
        for (JobDetailDto job : list) {
            this.quartzScheduler.deleteJob(JobKey.jobKey((String)job.getJobName(), (String)job.getJobGroup()));
        }
    }

    @Override
    public void pauseTriggers(List<TriggerDto> list) throws SchedulerException {
        for (TriggerDto trigger : list) {
            this.quartzScheduler.pauseTrigger(TriggerKey.triggerKey((String)trigger.getTriggerName(), (String)trigger.getTriggerGroup()));
        }
    }

    @Override
    public void resumeTriggers(List<TriggerDto> list) throws SchedulerException {
        for (TriggerDto trigger : list) {
            this.quartzScheduler.resumeTrigger(TriggerKey.triggerKey((String)trigger.getTriggerName(), (String)trigger.getTriggerGroup()));
        }
    }
}

