/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.job.listener;

import com.hand.hap.job.dto.JobRunningInfoDto;
import com.hand.hap.job.service.IJobRunningInfoService;
import org.quartz.JobKey;
import org.quartz.listeners.SchedulerListenerSupport;
import org.springframework.context.ApplicationContext;

public class SchedulerRunningListener
extends SchedulerListenerSupport {
    private static final String JOB_INFO_HAS_DELETED = "Job Info [{}.{}] has deleted.";
    private static final String JOB_WAS_DELETED_FROM_SCHEDULER = "Job [{}.{}] was deleted from Scheduler.";
    private final ApplicationContext applicationContext;

    public SchedulerRunningListener(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void jobDeleted(JobKey jobKey) {
        JobRunningInfoDto dto = new JobRunningInfoDto();
        String group = jobKey.getGroup();
        String name = jobKey.getName();
        this.logInfo(JOB_WAS_DELETED_FROM_SCHEDULER, group, name);
        dto.setJobName(name);
        dto.setJobGroup(group);
        this.deleteJobInfo(dto);
        this.logInfo(JOB_INFO_HAS_DELETED, group, name);
    }

    private void deleteJobInfo(JobRunningInfoDto jobCreateDto) {
        IJobRunningInfoService jobRunningInfoService = (IJobRunningInfoService)this.applicationContext.getBean(IJobRunningInfoService.class);
        jobRunningInfoService.delete(jobCreateDto);
    }

    protected void logInfo(String info, Object ... para) {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(info, para);
        }
    }

    protected void logInfo(String info) {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(info);
        }
    }
}

