/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.util;

import com.google.common.base.Throwables;
import com.hand.hap.api.logs.dto.ApiInvokeRecord;
import com.hand.hap.core.components.UserLoginInfoCollection;
import com.hand.hap.intergration.controllers.HapInvokeRequestBodyAdvice;
import com.hand.hap.intergration.dto.HapInterfaceInbound;
import com.hand.hap.intergration.dto.HapInterfaceOutbound;
import javax.servlet.http.HttpServletRequest;

public class HapInvokeLogUtils {
    public static String getRootCauseStackTrace(Throwable throwable) {
        Throwable t = Throwables.getRootCause((Throwable)throwable);
        String stackTrace = Throwables.getStackTraceAsString((Throwable)t);
        return stackTrace;
    }

    public static void processRequestInfo(HapInterfaceInbound inbound, HttpServletRequest request) {
        inbound.setUserAgent(request.getHeader("User-Agent"));
        if (inbound.getRequestMethod() == null) {
            inbound.setRequestMethod(request.getMethod());
        }
        if (inbound.getInterfaceUrl() == null) {
            inbound.setInterfaceUrl(request.getServletPath());
        }
        if (inbound.getRequestHeaderParameter() == null) {
            inbound.setRequestHeaderParameter(request.getQueryString());
        }
        if (inbound.getRequestBodyParameter() == null) {
            inbound.setRequestBodyParameter(HapInvokeRequestBodyAdvice.getAndRemoveBody());
        }
        inbound.setIp(UserLoginInfoCollection.getIpAddress(request));
    }

    public static void processExceptionInfo(HapInterfaceInbound inbound, Throwable throwable) {
        if (throwable != null) {
            inbound.setStackTrace(HapInvokeLogUtils.getRootCauseStackTrace(throwable));
            inbound.setRequestStatus("failure");
        }
    }

    public static void processExceptionInfo(HapInterfaceOutbound outbound, Throwable throwable) {
        if (throwable != null) {
            outbound.setStackTrace(HapInvokeLogUtils.getRootCauseStackTrace(throwable));
            outbound.setRequestStatus("failure");
        }
    }

    public static void processExceptionInfo(ApiInvokeRecord accessRecord, Throwable throwable) {
        if (throwable != null) {
            accessRecord.getApiInvokeRecordDetails().setStacktrace(HapInvokeLogUtils.getRootCauseStackTrace(throwable));
            accessRecord.setResponseStatus("failure");
        }
    }
}

