/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.hand.hap.intergration.beans.HapInvokeInfo;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.exception.HapApiException;
import com.hand.hap.intergration.service.IHapApiService;
import com.hand.hap.intergration.service.IHapAuthenticationService;
import com.hand.hap.intergration.util.JSONAndMap;
import com.hand.hap.mybatis.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HapSoapApiServiceImpl
implements IHapApiService {
    private static final Logger logger = LoggerFactory.getLogger(HapSoapApiServiceImpl.class);
    @Autowired
    private IHapAuthenticationService authenticationService;

    public Map soapSend(HapInterfaceHeader headerAndLineDTO, String xml) throws Exception {
        StringBuffer data = new StringBuffer();
        InputStream map = this.getSoapInputStream(xml, headerAndLineDTO);
        BufferedReader e = new BufferedReader(new InputStreamReader(map, "UTF-8"));
        String line = null;
        while (true) {
            if ((line = e.readLine()) == null) {
                e.close();
                map.close();
                break;
            }
            data.append(line);
        }
        map = null;
        try {
            Map map1 = JSONAndMap.xml2map(data.toString());
            HapInvokeInfo.OUTBOUND_RESPONSE_DATA.set(data.toString());
            return map1;
        }
        catch (Exception var7) {
            throw new HapApiException("error.format_xmlToMap", "ERROR XML 2 MAP");
        }
    }

    public InputStream getSoapInputStream(String xml, HapInterfaceHeader headerAndLineDTO) throws Exception {
        try {
            InputStream var12;
            String e = headerAndLineDTO.getDomainUrl() + headerAndLineDTO.getIftUrl();
            URL count1 = new URL(e);
            URLConnection conn = count1.openConnection();
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Length", Integer.toString(xml.length()));
            conn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            if (!StringUtil.isEmpty(headerAndLineDTO.getSoapAction())) {
                conn.setRequestProperty("SOAPAction", headerAndLineDTO.getSoapAction());
            }
            if ("Y".equalsIgnoreCase(headerAndLineDTO.getAuthFlag())) {
                String os;
                if ("BASIC_AUTH".equalsIgnoreCase(headerAndLineDTO.getAuthType())) {
                    os = headerAndLineDTO.getAuthUsername() + ":" + headerAndLineDTO.getAuthPassword();
                    String basicBase64 = new String(Base64.encodeBase64((byte[])os.getBytes()));
                    conn.setRequestProperty("Authorization", "Basic " + basicBase64);
                } else {
                    os = this.authenticationService.getToken(headerAndLineDTO);
                    if (StringUtil.isEmpty(os)) {
                        logger.error("get access_token failure,check your config");
                        throw new RuntimeException("get access_token failure,check your config");
                    }
                    conn.setRequestProperty("Authorization", "Bearer " + os);
                }
            }
            conn.connect();
            try (OutputStream os1 = conn.getOutputStream();
                 OutputStreamWriter osw = new OutputStreamWriter(os1, "utf-8");){
                InputStream is;
                osw.write(xml);
                osw.flush();
                var12 = is = conn.getInputStream();
            }
            return var12;
        }
        catch (IOException var41) {
            if ("Y".equalsIgnoreCase(headerAndLineDTO.getAuthFlag()) && "OAUTH2".equalsIgnoreCase(headerAndLineDTO.getAuthType()) && var41.getMessage().contains("response code: 401")) {
                logger.warn(var41.getMessage());
                this.authenticationService.updateToken(headerAndLineDTO);
                Integer count = HapInvokeInfo.TOKEN_TASK_COUNT.get();
                if (count != null && count > 0) {
                    logger.info("try get access_token times:" + count);
                    HapInvokeInfo.TOKEN_TASK_COUNT.set(count - 1);
                    return this.getSoapInputStream(xml, headerAndLineDTO);
                }
            }
            logger.error(var41.getMessage(), (Throwable)var41);
            throw var41;
        }
    }

    @Override
    public JSONObject invoke(HapInterfaceHeader headerAndLineDTO, JSONObject inbound) throws Exception {
        logger.info("inbound:{}", (Object)inbound);
        String xml = "";
        try {
            if (inbound != null) {
                xml = JSONAndMap.jsonToXml(inbound.toString(), headerAndLineDTO.getNamespace());
            }
        }
        catch (Exception var6) {
            logger.info("jsonToMap error:{}", (Throwable)var6);
            throw new HapApiException("error.format_jsonToMap", "jsonToMap error");
        }
        xml = headerAndLineDTO.getBodyHeader() + xml + headerAndLineDTO.getBodyTail();
        HapInvokeInfo.OUTBOUND_REQUEST_PARAMETER.set(xml);
        Map result = this.soapSend(headerAndLineDTO, xml);
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)result));
        return jsonObject;
    }
}

