/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.StringUtil;
import com.hand.hap.intergration.beans.HapTransferDataMapper;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapApiService;
import com.hand.hap.intergration.service.IHapAuthenticationService;
import com.hand.hap.intergration.utils.HttpUtil;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HapRestApiServiceImpl
implements IHapApiService {
    private final Logger logger = LoggerFactory.getLogger(HapRestApiServiceImpl.class);
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final int HTTP_OK = 200;
    private static final int HTTP_401 = 401;
    @Autowired
    private IHapAuthenticationService authenticationService;

    private String sendPost(String url, HapInterfaceHeader interfaceHeader, JSONObject params) throws Exception {
        HttpResponse execute = null;
        JSONObject headers = new JSONObject();
        String requestContentType = "";
        JSONObject responseBody = new JSONObject();
        requestContentType = interfaceHeader.getRequestContentType() != null ? interfaceHeader.getRequestContentType().toLowerCase() : APPLICATION_JSON;
        if (interfaceHeader.getAuthFlag().equals("Y")) {
            headers = this.processAuthAuthorization(interfaceHeader);
        }
        headers.put("Content-Type", (Object)requestContentType);
        execute = requestContentType.contains(APPLICATION_JSON) ? HttpUtil.postJson(url, params, headers) : (requestContentType.contains(APPLICATION_FORM_URLENCODED) ? HttpUtil.postFormUrlEncoded(url, params, headers) : (requestContentType.contains(APPLICATION_OCTET_STREAM) ? HttpUtil.postOcStremJson(url, params, headers) : HttpUtil.postJson(url, params, headers)));
        if (execute != null) {
            int httpReponseCode = execute.getStatusLine().getStatusCode();
            if (httpReponseCode != 200) {
                if (httpReponseCode == 401) {
                    this.authenticationService.updateToken(interfaceHeader);
                }
                responseBody.put("code", (Object)httpReponseCode);
                responseBody.put("message", (Object)execute.getStatusLine().getReasonPhrase());
                return responseBody.toString();
            }
            String httpResult = HttpUtil.HttpResponseParseJson(execute);
            return httpResult;
        }
        return "";
    }

    private String sendGet(String url, HapInterfaceHeader interfaceHeader, JSONObject params) throws Exception {
        HttpResponse execute = null;
        JSONObject headers = new JSONObject();
        String requestContentType = "";
        JSONObject responseBody = new JSONObject();
        if (params != null && params.size() > 0) {
            url = url + "?";
            StringBuffer parm = new StringBuffer();
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                parm.append(key + "=" + URLEncoder.encode(entry.getValue().toString(), "utf-8") + "&");
            }
            String p = parm.substring(0, parm.length() - 1);
            url = url + p;
        }
        requestContentType = interfaceHeader.getRequestContentType();
        requestContentType = interfaceHeader.getRequestContentType() != null ? interfaceHeader.getRequestContentType().toLowerCase() : APPLICATION_JSON;
        if (interfaceHeader.getAuthFlag().equals("Y")) {
            headers = this.processAuthAuthorization(interfaceHeader);
        }
        headers.put("Content-Type", (Object)requestContentType);
        execute = HttpUtil.getJson(url, headers);
        if (execute != null) {
            int httpReponseCode = execute.getStatusLine().getStatusCode();
            if (httpReponseCode != 200) {
                if (httpReponseCode == 401) {
                    this.authenticationService.updateToken(interfaceHeader);
                }
                responseBody.put("code", (Object)httpReponseCode);
                responseBody.put("message", (Object)execute.getStatusLine().getReasonPhrase());
                return responseBody.toString();
            }
            String httpResult = HttpUtil.HttpResponseParseJson(execute);
            return httpResult;
        }
        return "";
    }

    @Override
    public JSONObject invoke(HapInterfaceHeader headerAndLineDTO, JSONObject inbound) throws Exception {
        String url = headerAndLineDTO.getDomainUrl() + headerAndLineDTO.getIftUrl();
        this.logger.info("request url:{}", (Object)url);
        String data = null;
        JSONObject json = null;
        String inboundParam = " ";
        HapTransferDataMapper mapper = null;
        if (StringUtil.isNotEmpty(headerAndLineDTO.getMapperClass())) {
            ClassLoader jsonConfig = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> e = jsonConfig.loadClass(headerAndLineDTO.getMapperClass());
                mapper = (HapTransferDataMapper)e.newInstance();
            }
            catch (ClassNotFoundException var10) {
                this.logger.error("ClassNotFoundException:" + var10.getMessage());
                throw var10;
            }
            catch (InstantiationException var11) {
                this.logger.error("InstantiationException:" + var11.getMessage());
                throw var11;
            }
            catch (IllegalAccessException var12) {
                this.logger.error("IllegalAccessException:" + var12.getMessage());
                throw var12;
            }
        }
        if (mapper != null) {
            inboundParam = mapper.requestDataMap(inbound);
            inbound = JSONObject.parseObject((String)inboundParam);
        }
        if (headerAndLineDTO.getRequestMethod().equals("POST")) {
            if (inbound != null) {
                inboundParam = inbound.toString();
            }
            if (url.contains(".svc") || url.contains(".lsc")) {
                inboundParam = "{\"_request_data\":{\"parameter\":" + inboundParam + "}}";
            }
            inbound = JSONObject.parseObject((String)inboundParam);
            this.logger.info("params Xml :{}", (Object)inboundParam);
            data = this.sendPost(url, headerAndLineDTO, inbound);
        } else if (headerAndLineDTO.getRequestMethod().equals("GET")) {
            data = this.sendGet(url, headerAndLineDTO, inbound);
        }
        json = JSONObject.parseObject(data);
        return json;
    }

    private JSONObject processAuthAuthorization(HapInterfaceHeader headerAndLineDTO) throws Exception {
        JSONObject headers = new JSONObject();
        if ("BASIC_AUTH".equalsIgnoreCase(headerAndLineDTO.getAuthType())) {
            String e = headerAndLineDTO.getAuthUsername() + ":" + headerAndLineDTO.getAuthPassword();
            String accessToken = new String(Base64.encodeBase64((byte[])e.getBytes()));
            headers.put("Authorization", (Object)("Basic " + accessToken));
        } else if ("OAUTH2".equalsIgnoreCase(headerAndLineDTO.getAuthType())) {
            String accessToken = this.authenticationService.getToken(headerAndLineDTO);
            if (StringUtil.isEmpty(accessToken)) {
                this.logger.error("get access_token failure,check your config");
            }
            headers.put("Authorization", (Object)("Bearer " + accessToken));
        }
        return headers;
    }
}

