/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.core.BaseConstants;
import com.hand.hap.intergration.service.AuthenticationAdapter;
import com.hand.hap.intergration.service.IHapAuthenticationService;
import com.hand.hap.mybatis.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class HapAuthenticationServiceImpl
implements IHapAuthenticationService,
BaseConstants {
    private Logger logger = LoggerFactory.getLogger(HapAuthenticationServiceImpl.class);
    public static final String AUTH_TPYE_BASIC = "BASIC_AUTH";
    public static final String AUTH_TYPE_OAUTH2 = "OAUTH2";
    public static final String GRANT_TYPE_CLIENT = "client_credentials";
    public static final String GRANT_TYPE_CODE = "authorization_code";
    public static final String GRANT_TYPE_REFRESH = "refresh_token";
    public static final String GRANT_TYPE_PASSWORD = "password";
    public static final String AUTH_ACCESS_TOKEN = "access_token";
    public static final String AUTH_EXPIRES_IN = "expires_in";
    private final Integer DEFAULT_TOKEN_EXPIRE_TIME = 86400;
    private final Integer DEFAULT_REFESH_TOKEN_EXPIRE_TIME = 2592000;
    private final String redisCatalog = "hap:cache:interface:auth:";
    private static ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public String getToken(AuthenticationAdapter authenticationAdapter) {
        if (!this.checkParm(authenticationAdapter)) {
            return null;
        }
        String accessTokenKey = "hap:cache:interface:auth:" + authenticationAdapter.getAccessTokenKey() + AUTH_ACCESS_TOKEN;
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)accessTokenKey);
        if (StringUtil.isEmpty(accessToken)) {
            return this.updateToken(authenticationAdapter);
        }
        return accessToken;
    }

    @Override
    public String updateToken(AuthenticationAdapter authenticationAdapter) {
        Map response;
        String refreshToken;
        if (!this.checkParm(authenticationAdapter)) {
            return null;
        }
        String type = authenticationAdapter.getGrantType();
        String clientId = authenticationAdapter.getClientId();
        String clientSecret = authenticationAdapter.getClientSecret();
        String scope = authenticationAdapter.getScope();
        String username = authenticationAdapter.getAuthUsername();
        String password = authenticationAdapter.getAuthPassword();
        String accessToken = null;
        String accessTokenKey = "hap:cache:interface:auth:" + authenticationAdapter.getAccessTokenKey() + AUTH_ACCESS_TOKEN;
        String refreshTokenKey = "hap:cache:interface:auth:" + authenticationAdapter.getRefreshTokenKey() + GRANT_TYPE_REFRESH;
        StringBuilder parm = new StringBuilder();
        parm.append("grant_type=" + type).append("&client_id=" + clientId).append("&client_secret=" + clientSecret);
        if (GRANT_TYPE_PASSWORD.equalsIgnoreCase(type)) {
            parm.append("&username=" + username).append("&password=" + password);
        }
        if (StringUtil.isNotEmpty(scope)) {
            parm.append("&scope=" + scope);
        }
        if (StringUtil.isNotEmpty(refreshToken = (String)this.redisTemplate.opsForValue().get((Object)refreshTokenKey))) {
            StringBuilder refreshParm = new StringBuilder();
            refreshParm.append("grant_type=refresh_token").append("&refresh_token=" + refreshToken).append("&client_id=" + clientId).append("&client_secret=" + clientSecret);
            Map response2 = this.getResponseData(authenticationAdapter.getAccessTokenUrl(), refreshParm);
            if (response2 != null) {
                Object tokenObj = response2.get(AUTH_ACCESS_TOKEN);
                if (tokenObj != null) {
                    accessToken = tokenObj.toString();
                    this.updateRedisRecord(response2, accessTokenKey, refreshTokenKey, accessToken);
                    return accessToken;
                }
            } else {
                this.redisTemplate.opsForValue().set((Object)refreshTokenKey, (Object)"");
            }
        }
        if ((response = this.getResponseData(authenticationAdapter.getAccessTokenUrl(), parm)) != null) {
            Object tokenObj = response.get(AUTH_ACCESS_TOKEN);
            if (tokenObj != null) {
                accessToken = tokenObj.toString();
                this.updateRedisRecord(response, accessTokenKey, refreshTokenKey, accessToken);
                return accessToken;
            }
        } else {
            this.redisTemplate.opsForValue().set((Object)accessTokenKey, (Object)"");
        }
        return accessToken;
    }

    private void updateRedisRecord(Map response, String atokenKey, String rtokenKey, String accessToken) {
        Integer exp = this.DEFAULT_TOKEN_EXPIRE_TIME;
        Object expiresObj = response.get(AUTH_EXPIRES_IN);
        if (expiresObj != null) {
            exp = Integer.parseInt(expiresObj.toString());
        }
        this.redisTemplate.opsForValue().set((Object)atokenKey, (Object)accessToken, (long)exp.intValue(), TimeUnit.SECONDS);
        Object refeshObj = response.get(GRANT_TYPE_REFRESH);
        if (refeshObj != null) {
            this.redisTemplate.opsForValue().set((Object)rtokenKey, (Object)refeshObj.toString(), (long)this.DEFAULT_REFESH_TOKEN_EXPIRE_TIME.intValue(), TimeUnit.SECONDS);
        }
    }

    private boolean checkParm(AuthenticationAdapter authenticationAdapter) {
        if (StringUtil.isEmpty(authenticationAdapter.getAccessTokenUrl())) {
            this.logger.error("access token url is null");
            return false;
        }
        if (StringUtil.isEmpty(authenticationAdapter.getClientId())) {
            this.logger.error("client id is null");
            return false;
        }
        if (StringUtil.isEmpty(authenticationAdapter.getClientSecret())) {
            this.logger.error("client secret  is null");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getResponseData(String url, StringBuilder parm) {
        Map result = null;
        HttpURLConnection connection = null;
        try {
            URL authURL = new URL(url);
            connection = url.contains("https") ? (HttpsURLConnection)authURL.openConnection() : (HttpURLConnection)authURL.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.connect();
            try (OutputStream outputStream = connection.getOutputStream();){
                outputStream.write(parm.toString().getBytes("UTF-8"));
                outputStream.flush();
            }
            if (connection.getResponseCode() != 200) {
                this.logger.warn("HTTP GET Request Failed with Error code : " + connection.getResponseCode());
                connection.disconnect();
                outputStream = null;
                return outputStream;
            }
            var7_9 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));){
                String line;
                StringBuilder results = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    results.append(line);
                }
                result = (Map)objectMapper.readValue(results.toString(), Map.class);
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
        }
        catch (MalformedURLException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result;
    }
}

