/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.TokenException;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.intergration.service.IHapInterfaceLineService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/api", "/sys/interface", "/api/sys/interface"})
public class HapInterfaceHeaderController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(HapInterfaceHeaderController.class);
    @Autowired
    private IHapInterfaceHeaderService headerService;
    @Autowired
    private IHapInterfaceLineService lineService;

    @RequestMapping(value={"/queryAllHeader"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData getHeaderList(HttpServletRequest request, HapInterfaceHeader headerAndHeaderTlDTO, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest iRequest = this.createRequestContext(request);
        List<HapInterfaceHeader> list = this.headerService.getAllHeader(iRequest, headerAndHeaderTlDTO, page, pagesize);
        return new ResponseData(list);
    }

    @RequestMapping(value={"/submit"}, method={RequestMethod.POST})
    public ResponseData submitCode(@RequestBody List<HapInterfaceHeader> interfaces, BindingResult result, HttpServletRequest request) throws TokenException {
        this.checkToken(request, interfaces);
        this.getValidator().validate(interfaces, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.headerService.batchUpdate(requestContext, interfaces));
    }

    @RequestMapping(value={"/addHeader"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData addHeader(HttpServletRequest request, @RequestBody HapInterfaceHeader hapInterfaceHeader, BindingResult result) {
        this.getValidator().validate((Object)hapInterfaceHeader, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest iRequest = this.createRequestContext(request);
        hapInterfaceHeader.setHeaderId(UUID.randomUUID().toString());
        hapInterfaceHeader.setDescription(hapInterfaceHeader.getName());
        HapInterfaceHeader hapInterfaceHeaderNew = this.headerService.insertSelective(iRequest, hapInterfaceHeader);
        if (hapInterfaceHeaderNew != null) {
            return new ResponseData();
        }
        return new ResponseData(false);
    }

    @RequestMapping(value={"/updateHeader"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData updateHeader(HttpServletRequest request, @RequestBody HapInterfaceHeader hapInterfaceHeader, BindingResult result) {
        this.getValidator().validate((Object)hapInterfaceHeader, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest iRequest = this.createRequestContext(request);
        hapInterfaceHeader.setDescription(hapInterfaceHeader.getName());
        int updateRow = this.headerService.updateHeader(iRequest, hapInterfaceHeader);
        if (updateRow > 0) {
            return new ResponseData(true);
        }
        return new ResponseData(false);
    }

    @RequestMapping(value={"/deleteHeader"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData deleteHeader(HttpServletRequest request, @RequestBody List<HapInterfaceHeader> interfaceHeaders) {
        IRequest iRequest = this.createRequestContext(request);
        this.lineService.batchDeleteByHeaders(iRequest, interfaceHeaders);
        this.headerService.batchDelete(interfaceHeaders);
        return new ResponseData();
    }

    @RequestMapping(value={"/getHeaderAndLine"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData getHeaderAndLine(HttpServletRequest request, @RequestBody HapInterfaceHeader headerAndHeaderTlDTO) {
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.headerService.getHeaderAndLineList(iRequest, headerAndHeaderTlDTO));
    }

    @RequestMapping(value={"/getHeaderByHeaderId"})
    @ResponseBody
    public ResponseData getHeaderByHeaderId(HttpServletRequest request, HapInterfaceHeader headerAndHeaderTlDTO) {
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.headerService.getHeaderByHeaderId(iRequest, headerAndHeaderTlDTO));
    }

    @RequestMapping(value={"/getHeaderAndLineByLineId"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData getHeaderAndLineByLineId(HttpServletRequest request, HapInterfaceHeader headerAndLineDTO) {
        this.logger.info("getHeaderAndLineByLineId lineId:{}", (Object)headerAndLineDTO.getLineId());
        HapInterfaceHeader headerAndLineDTO1 = this.headerService.getHeaderAndLineByLineId(headerAndLineDTO);
        return new ResponseData(Arrays.asList(headerAndLineDTO1));
    }

    @RequestMapping(value={"/getAllHeaderAndLine"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData getAllHeaderAndLine(HttpServletRequest request, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        return new ResponseData(this.headerService.getAllHeaderAndLine(page, pagesize));
    }
}

