/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.aop;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.intergration.annotation.HapInbound;
import com.hand.hap.intergration.annotation.HapOutbound;
import com.hand.hap.intergration.beans.HapInvokeInfo;
import com.hand.hap.intergration.beans.HapinterfaceBound;
import com.hand.hap.intergration.controllers.HapApiController;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.dto.HapInterfaceInbound;
import com.hand.hap.intergration.dto.HapInterfaceOutbound;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.intergration.util.HapInvokeLogUtils;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.system.dto.ResponseData;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.ModelAndView;

@Aspect
@Component
public class HapInvokeAspect {
    @Autowired
    private IMessagePublisher messagePublisher;
    @Autowired
    private IHapInterfaceHeaderService headerService;
    @Autowired
    private ObjectMapper objectMapper;
    private static final Logger logger = LoggerFactory.getLogger(HapInvokeAspect.class);

    @Pointcut(value="@annotation(com.hand.hap.intergration.annotation.HapOutbound)")
    public void outboundAspect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(bound)")
    public Object aroundMethod(ProceedingJoinPoint pjd, HapOutbound bound) throws Throwable {
        Long startTime = System.currentTimeMillis();
        Object result = null;
        Throwable throwable = null;
        HapInterfaceOutbound outbound = new HapInterfaceOutbound();
        HapInvokeInfo.OUTBOUND.set(outbound);
        try {
            outbound.setRequestTime(new Date());
            Object[] args = pjd.getArgs();
            String sysName = null;
            String apiName = null;
            for (Object obj : args) {
                if (!(obj instanceof HttpServletRequest)) continue;
                sysName = ((HttpServletRequest)obj).getParameter("sysName");
                apiName = ((HttpServletRequest)obj).getParameter("apiName");
            }
            if (sysName == null && apiName == null) {
                sysName = bound.sysName();
                apiName = bound.apiName();
            }
            outbound.setInterfaceName(sysName + "-" + apiName);
            HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
            if (hapInterfaceHeader != null) {
                outbound.setInterfaceUrl(hapInterfaceHeader.getDomainUrl() + hapInterfaceHeader.getIftUrl());
            } else {
                outbound.setInterfaceUrl(" ");
            }
            result = pjd.proceed();
            if (HapInvokeInfo.OUTBOUND_REQUEST_PARAMETER.get() != null) {
                outbound.setRequestParameter(HapInvokeInfo.OUTBOUND_REQUEST_PARAMETER.get());
            }
            if (HapInvokeInfo.HTTP_RESPONSE_CODE.get() != null) {
                outbound.setResponseCode(HapInvokeInfo.HTTP_RESPONSE_CODE.get().toString());
            }
            if (HapInvokeInfo.OUTBOUND_RESPONSE_DATA.get() != null) {
                outbound.setResponseContent(HapInvokeInfo.OUTBOUND_RESPONSE_DATA.get());
            } else if (result != null) {
                outbound.setResponseContent(result.toString());
            }
            outbound.setRequestStatus("success");
            HapInterfaceInbound inbound = HapInvokeInfo.INBOUND.get();
            if (inbound != null) {
                if (inbound.getStackTrace() != null) {
                    outbound.setStackTrace(inbound.getStackTrace());
                    outbound.setRequestStatus("failure");
                }
                HapInvokeInfo.INBOUND.remove();
            }
        }
        catch (Throwable e) {
            throwable = e;
            result = new JSONObject();
            result.put((Object)"error", (Object)e.getMessage());
        }
        finally {
            outbound.setResponseTime(System.currentTimeMillis() - startTime);
            HapInvokeLogUtils.processExceptionInfo(outbound, throwable);
            HapinterfaceBound hapinterfaceBound = new HapinterfaceBound(outbound);
            this.messagePublisher.publish("invoke.outbound", hapinterfaceBound);
            HapInvokeInfo.clearOutboundInfo();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(bound)")
    public Object inaroundMethod(ProceedingJoinPoint pjd, HapInbound bound) throws Throwable {
        Long startTime = System.currentTimeMillis();
        Object result = null;
        Throwable throwable = null;
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        HapInterfaceInbound inbound = new HapInterfaceInbound();
        HapInvokeInfo.INBOUND.set(inbound);
        HapInvokeInfo.TOKEN_TASK_COUNT.set(5);
        try {
            inbound.setRequestTime(new Date());
            inbound.setInterfaceName(bound.apiName());
            result = pjd.proceed();
            if (result != null) {
                String content = "";
                content = result instanceof ResponseData ? this.objectMapper.writeValueAsString(result) : (result instanceof ModelAndView ? result.toString() : (result instanceof String ? (String)result : result.toString()));
                inbound.setResponseContent(content);
            }
            inbound.setRequestStatus("success");
            HapInterfaceOutbound outbound = HapInvokeInfo.OUTBOUND.get();
            if (outbound != null) {
                if (outbound.getStackTrace() != null) {
                    inbound.setStackTrace(outbound.getStackTrace());
                    inbound.setRequestStatus("failure");
                }
                HapInvokeInfo.OUTBOUND.remove();
            }
        }
        catch (Throwable e) {
            throwable = e;
            if (pjd.getTarget().getClass().getName().equalsIgnoreCase(HapApiController.class.getName())) {
                result = new JSONObject();
                ((JSONObject)result).put((Object)"error", (Object)e.getMessage());
            }
        }
        finally {
            Long endTime = System.currentTimeMillis();
            inbound.setResponseTime(endTime - startTime);
            HapInvokeLogUtils.processRequestInfo(inbound, request);
            HapInvokeLogUtils.processExceptionInfo(inbound, throwable);
            HapinterfaceBound hapinterfaceBound = new HapinterfaceBound(inbound);
            this.messagePublisher.publish("invoke.inbound", hapinterfaceBound);
            HapInvokeInfo.TOKEN_TASK_COUNT.remove();
        }
        return result;
    }
}

