/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.hr.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.account.dto.User;
import com.hand.hap.account.dto.UserRole;
import com.hand.hap.account.mapper.UserRoleMapper;
import com.hand.hap.account.service.IUserRoleService;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.core.IRequest;
import com.hand.hap.hr.dto.Employee;
import com.hand.hap.hr.dto.UserAndRoles;
import com.hand.hap.hr.mapper.EmployeeAssignMapper;
import com.hand.hap.hr.mapper.EmployeeMapper;
import com.hand.hap.hr.service.IEmployeeService;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class EmployeeServiceImpl
extends BaseServiceImpl<Employee>
implements IEmployeeService {
    @Autowired
    EmployeeMapper employeeMapper;
    @Autowired
    private IMessagePublisher messagePublisher;
    @Autowired
    private IUserRoleService userRoleService;
    @Autowired
    private IUserService userService;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private EmployeeAssignMapper employeeAssignMapper;

    @Override
    public List<Employee> submit(IRequest request, List<Employee> list) {
        ((IEmployeeService)this.self()).batchUpdate(request, list);
        for (Employee e : list) {
            this.messagePublisher.publish("employee.change", e);
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Employee> batchUpdate(IRequest request, List<Employee> list) {
        Criteria criteria = new Criteria();
        criteria.update("bornDate", "certificateId", "certificateType", "name", "effectiveEndDate", "effectiveStartDate", "email", "enabledFlag", "gender", "joinDate", "mobil", "status");
        for (Employee employee : list) {
            switch (employee.get__status()) {
                case "add": {
                    ((IEmployeeService)this.self()).insertSelective(request, employee);
                    break;
                }
                case "update": {
                    ((IEmployeeService)this.self()).updateByPrimaryKeyOptions(request, employee, null);
                    break;
                }
                case "delete": {
                    ((IEmployeeService)this.self()).deleteByPrimaryKey(employee);
                    break;
                }
            }
        }
        return list;
    }

    @Override
    public List<Employee> queryAll(IRequest requestContext, Employee employee, int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        return this.employeeMapper.queryAll(employee);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createUserByEmployee(IRequest request, UserAndRoles roles) {
        User u = this.userService.insertSelective(request, roles.getUser());
        if (null != roles.getRoles()) {
            Long userId = u.getUserId();
            List<UserRole> roles1 = roles.getRoles();
            for (UserRole role : roles1) {
                role.setUserId(userId);
                this.userRoleService.insertSelective(request, role);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUser(IRequest irequest, UserAndRoles userAndRoles) {
        if (userAndRoles.getRoles() != null) {
            List<UserRole> newRoles = userAndRoles.getRoles();
            User user = userAndRoles.getUser();
            this.userRoleMapper.deleteByUserId(user.getUserId());
            for (UserRole role : newRoles) {
                role.setUserId(user.getUserId());
                this.userRoleService.insertSelective(irequest, role);
            }
        }
    }

    @Override
    public Employee queryInfoByCode(String employeeCode) {
        return this.employeeMapper.queryInfoByCode(employeeCode);
    }

    @Override
    public List<Employee> selectByPostionCode(String code) {
        return this.employeeMapper.selectByPostionCode(code);
    }

    @Override
    public List<Employee> getDirector(String employeeCode) {
        return this.employeeMapper.getDirector(employeeCode);
    }

    @Override
    public List<Employee> getDeptDirector(String employeeCode) {
        return this.employeeMapper.getDeptDirector(employeeCode);
    }

    @Override
    public int deleteByPrimaryKey(Employee employee) {
        int result = super.deleteByPrimaryKey(employee);
        this.employeeAssignMapper.deleteByEmployeeId(employee.getEmployeeId());
        return result;
    }
}

