/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.hr.dto;

import com.hand.hap.core.annotation.MultiLanguage;
import com.hand.hap.core.annotation.MultiLanguageField;
import com.hand.hap.hr.dto.HrOrgUnit;
import com.hand.hap.mybatis.common.query.Comparison;
import com.hand.hap.mybatis.common.query.JoinColumn;
import com.hand.hap.mybatis.common.query.JoinOn;
import com.hand.hap.mybatis.common.query.JoinTable;
import com.hand.hap.mybatis.common.query.Where;
import com.hand.hap.system.dto.BaseDTO;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.criteria.JoinType;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@MultiLanguage
@Table(name="hr_org_position_b")
public class Position
extends BaseDTO {
    public static final String FIELD_POSITION_ID = "positionId";
    public static final String FIELD_UNIT_ID = "unitId";
    public static final String FIELD_UNIT_NAME = "unitName";
    public static final String FIELD_POSITION_CODE = "positionCode";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_PARENT_POSITION_ID = "parentPositionId";
    public static final String FIELD_PARENT_POSITION_NAME = "parentPositionName";
    private static final long serialVersionUID = 1L;
    @Id
    @Where
    @GeneratedValue
    private Long positionId;
    @JoinTable(name="unitJoin", joinMultiLanguageTable=true, target=HrOrgUnit.class, type=JoinType.LEFT, on={@JoinOn(joinField="unitId"), @JoinOn(joinField="lang", joinExpression="#{request.locale,jdbcType=VARCHAR,javaType=java.lang.String}")})
    private Long unitId;
    @Transient
    @JoinColumn(joinName="unitJoin", field="name")
    @NotEmpty
    private String unitName;
    @Where
    @Length(max=50)
    @NotEmpty
    @OrderBy(value="ASC")
    private String positionCode;
    @MultiLanguageField
    @Where(comparison=Comparison.LIKE)
    @Length(max=100)
    @NotEmpty
    private String name;
    @MultiLanguageField
    @Length(max=255)
    private String description;
    @Where
    @JoinTable(name="positionJoin", joinMultiLanguageTable=true, target=Position.class, type=JoinType.LEFT, on={@JoinOn(joinField="positionId"), @JoinOn(joinField="lang", joinExpression="#{request.locale,jdbcType=VARCHAR,javaType=java.lang.String}")})
    private Long parentPositionId;
    @Transient
    @JoinColumn(joinName="positionJoin", field="name")
    private String parentPositionName;

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getParentPositionName() {
        return this.parentPositionName;
    }

    public void setParentPositionName(String parentPositionName) {
        this.parentPositionName = parentPositionName;
    }

    public Long getPositionId() {
        return this.positionId;
    }

    public void setPositionId(Long positionId) {
        this.positionId = positionId;
    }

    public Long getUnitId() {
        return this.unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getPositionCode() {
        return this.positionCode;
    }

    public void setPositionCode(String positionCode) {
        this.positionCode = StringUtils.trim((String)positionCode);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getParentPositionId() {
        return this.parentPositionId;
    }

    public void setParentPositionId(Long parentPositionId) {
        this.parentPositionId = parentPositionId;
    }
}

