/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.hr.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.hr.dto.HrOrgUnit;
import com.hand.hap.hr.service.IOrgUnitService;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hr/unit", "/api/hr/unit"})
public class UnitController
extends BaseController {
    @Autowired
    IOrgUnitService service;

    @RequestMapping(value={"/query"})
    @ResponseBody
    public ResponseData query(HttpServletRequest request, HrOrgUnit unit, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.selectOptions(requestCtx, unit, null, page, pagesize));
    }

    @RequestMapping(value={"/queryall"})
    @ResponseBody
    public ResponseData queryAllUnits(HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        Criteria criteria = new Criteria();
        criteria.select("parentName", "name", "unitCode", "description", "unitId", "parentId", "positionName");
        HrOrgUnit unit = new HrOrgUnit();
        unit.setEnabledFlag("Y");
        return new ResponseData(this.service.selectOptions(requestCtx, unit, criteria));
    }

    @RequestMapping(value={"/submit"})
    @ResponseBody
    public ResponseData update(HttpServletRequest request, @RequestBody List<HrOrgUnit> units, BindingResult result) {
        this.getValidator().validate(units, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, units));
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<HrOrgUnit> units) {
        this.service.batchDelete(units);
        return new ResponseData();
    }
}

