/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.service.impl;

import com.hand.hap.cache.impl.ResourceItemAssignCache;
import com.hand.hap.cache.impl.ResourceItemCache;
import com.hand.hap.cache.impl.ResourceItemElementCache;
import com.hand.hap.cache.impl.RoleResourceItemCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.function.dto.Function;
import com.hand.hap.function.dto.MenuItem;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.function.dto.ResourceItem;
import com.hand.hap.function.dto.ResourceItemAssign;
import com.hand.hap.function.dto.ResourceItemCount;
import com.hand.hap.function.dto.ResourceItemElement;
import com.hand.hap.function.dto.RoleResourceItem;
import com.hand.hap.function.mapper.FunctionMapper;
import com.hand.hap.function.mapper.ResourceItemAssignMapper;
import com.hand.hap.function.mapper.ResourceItemElementMapper;
import com.hand.hap.function.mapper.ResourceItemMapper;
import com.hand.hap.function.mapper.RoleResourceItemMapper;
import com.hand.hap.function.service.IFunctionService;
import com.hand.hap.function.service.IRoleResourceItemService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.logstash.logback.encoder.org.apache.commons.lang.ArrayUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class RoleResourceItemServiceImpl
implements IRoleResourceItemService {
    @Autowired
    private ResourceItemMapper resourceItemMapper;
    @Autowired
    private RoleResourceItemMapper roleResourceItemMapper;
    @Autowired
    private FunctionMapper functionMapper;
    @Autowired
    private ResourceItemCache resourceItemCache;
    @Autowired
    private RoleResourceItemCache roleResourceItemCache;
    @Autowired
    private IFunctionService functionService;
    @Autowired
    private ResourceItemAssignMapper resourceItemAssignMapper;
    @Autowired
    private ResourceItemElementMapper resourceItemElementMapper;
    @Autowired
    private ResourceItemAssignCache resourceItemAssignCache;
    @Autowired
    private ResourceItemElementCache resourceItemElementCache;

    @Override
    @Deprecated
    public List<String> getNotAccessItems(Resource resource, Long roleId) {
        Object[] resourceItems = this.resourceItemCache.getValue(resource.getResourceId().toString());
        Object[] roleResourceItemIds = this.roleResourceItemCache.getValue(roleId.toString());
        ArrayList<String> notAccessItems = new ArrayList<String>();
        if (ArrayUtils.isNotEmpty((Object[])resourceItems)) {
            for (Object resourceItem : resourceItems) {
                boolean notAccessItem = true;
                if (ArrayUtils.isNotEmpty((Object[])roleResourceItemIds)) {
                    for (Object roleResourceItemId : roleResourceItemIds) {
                        if (!((Long)roleResourceItemId).equals(((ResourceItem)resourceItem).getResourceItemId())) continue;
                        notAccessItem = false;
                        break;
                    }
                }
                if (!notAccessItem) continue;
                notAccessItems.add(((ResourceItem)resourceItem).getItemId());
            }
        }
        return notAccessItems;
    }

    @Override
    public List<Resource> queryHtmlResources(IRequest requestContext, Function function) {
        Resource resource = new Resource();
        resource.setType("HTML");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("function", function);
        params.put("resource", resource);
        return this.functionMapper.selectExistsResourcesByFunction(params);
    }

    @Override
    public List<MenuItem> queryResourceItems(IRequest requestContext, Long roleId, Long functionId) {
        Function function = new Function();
        function.setFunctionId(functionId);
        List<MenuItem> menus = this.createResources(this.queryHtmlResources(requestContext, function));
        Long[] roleResourceItemIds = null;
        ResourceItemAssign[] resourceItemAssigns = null;
        if (roleId != null) {
            roleResourceItemIds = this.roleResourceItemCache.getValue(roleId.toString());
            resourceItemAssigns = this.resourceItemAssignCache.getValue("role_" + roleId);
        }
        this.updateMenuCheck(menus, roleResourceItemIds, resourceItemAssigns);
        return menus;
    }

    private void updateMenuCheck(List<MenuItem> menus, Long[] roleResourceItemIds, ResourceItemAssign[] resourceItemAssigns) {
        if (CollectionUtils.isEmpty(menus) || ArrayUtils.isEmpty((Object[])roleResourceItemIds) && ArrayUtils.isEmpty((Object[])resourceItemAssigns)) {
            return;
        }
        block0: for (MenuItem menuItem : menus) {
            if (CollectionUtils.isNotEmpty(menuItem.getChildren())) {
                this.updateMenuCheck(menuItem.getChildren(), roleResourceItemIds, resourceItemAssigns);
            }
            if ("oldData".equalsIgnoreCase(menuItem.getFunctionCode())) {
                if (!ArrayUtils.isNotEmpty((Object[])roleResourceItemIds)) continue;
                for (Serializable serializable : roleResourceItemIds) {
                    if (!menuItem.getId().equals(serializable)) continue;
                    menuItem.setIschecked(Boolean.TRUE);
                    continue block0;
                }
                continue;
            }
            if (!"newData".equalsIgnoreCase(menuItem.getFunctionCode()) || !ArrayUtils.isNotEmpty((Object[])resourceItemAssigns)) continue;
            for (Serializable serializable : resourceItemAssigns) {
                if (!menuItem.getId().equals(((ResourceItemAssign)serializable).getElementId())) continue;
                menuItem.setIschecked(Boolean.FALSE);
                continue block0;
            }
        }
    }

    @Override
    public List<MenuItem> createResources(List<Resource> resourceList) {
        MenuItem root = new MenuItem();
        ArrayList<MenuItem> children = new ArrayList<MenuItem>();
        root.setChildren(children);
        if (resourceList != null) {
            ResourceItemCount itemCount = new ResourceItemCount();
            for (Resource resource : resourceList) {
                MenuItem resourceMenu = this.createResourceItems(resource, itemCount);
                if (resourceMenu == null) continue;
                children.add(resourceMenu);
            }
        }
        return root.getChildren();
    }

    private MenuItem createResourceItems(Resource resource, ResourceItemCount itemCount) {
        Object[] resourceItemList = this.resourceItemCache.getValue(resource.getResourceId().toString());
        MenuItem resourceMenu = null;
        if (ArrayUtils.isNotEmpty((Object[])resourceItemList)) {
            resourceMenu = new MenuItem();
            resourceMenu.setText(resource.getName() + "(" + resource.getUrl() + ")");
            resourceMenu.setId(itemCount.getResourceId());
            itemCount.setResourceId(itemCount.getResourceId() - 10L);
            resourceMenu.setIcon("fa fa-file");
            ArrayList<MenuItem> resourceMenuChildren = new ArrayList<MenuItem>();
            resourceMenu.setChildren(resourceMenuChildren);
            ArrayList<ResourceItem> variateList = new ArrayList<ResourceItem>();
            ArrayList<ResourceItem> buttonList = new ArrayList<ResourceItem>();
            ArrayList<ResourceItem> formList = new ArrayList<ResourceItem>();
            ArrayList<ResourceItem> gridList = new ArrayList<ResourceItem>();
            block12: for (Object resourceItem : resourceItemList) {
                String itemType;
                switch (itemType = ((ResourceItem)resourceItem).getItemType()) {
                    case "variable": {
                        variateList.add((ResourceItem)resourceItem);
                        continue block12;
                    }
                    case "buttons": {
                        buttonList.add((ResourceItem)resourceItem);
                        continue block12;
                    }
                    case "form": {
                        formList.add((ResourceItem)resourceItem);
                        continue block12;
                    }
                    case "grid": {
                        gridList.add((ResourceItem)resourceItem);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(variateList)) {
                this.resourceMenu(variateList, resourceMenuChildren, itemCount);
            }
            if (CollectionUtils.isNotEmpty(buttonList)) {
                this.resourceMenu(buttonList, resourceMenuChildren, itemCount);
            }
            if (CollectionUtils.isNotEmpty(formList)) {
                this.resourceMenu(formList, resourceMenuChildren, itemCount);
            }
            if (CollectionUtils.isNotEmpty(gridList)) {
                this.resourceMenu(gridList, resourceMenuChildren, itemCount);
            }
            if (CollectionUtils.isEmpty(resourceMenu.getChildren())) {
                return null;
            }
        }
        return resourceMenu;
    }

    private void resourceMenu(List<ResourceItem> resourceItemList, List<MenuItem> resourceMenuChildren, ResourceItemCount itemCount) {
        String itemType = resourceItemList.get(0).getItemType();
        if ("variable".equalsIgnoreCase(itemType)) {
            MenuItem variateMenu = new MenuItem();
            variateMenu.setText("\u670d\u52a1\u7aef\u53d8\u91cf");
            variateMenu.setId(itemCount.getVariateId());
            variateMenu.setIschecked(Boolean.FALSE);
            variateMenu.setIcon("fa fa-info-circle");
            itemCount.setVariateId(itemCount.getVariateId() - 10L);
            resourceMenuChildren.add(variateMenu);
            ArrayList<MenuItem> variateMenuChildren = new ArrayList<MenuItem>();
            variateMenu.setChildren(variateMenuChildren);
            for (ResourceItem resourceItem : resourceItemList) {
                MenuItem variate = new MenuItem();
                variate.setText(resourceItem.getItemName());
                variate.setId(resourceItem.getResourceItemId());
                variate.setIcon("fa fa-pencil-square-o");
                variate.setFunctionCode("oldData");
                variateMenuChildren.add(variate);
            }
        } else {
            for (ResourceItem resourceItem : resourceItemList) {
                MenuItem menu = this.createResourceItemElements(resourceItem, itemCount);
                if (menu == null) continue;
                resourceMenuChildren.add(menu);
            }
        }
    }

    private String translateItemType(String type) {
        switch (type) {
            case "form": {
                type = "\u8868\u5355";
                break;
            }
            case "grid": {
                type = "\u8868\u683c";
                break;
            }
            case "buttons": {
                type = "\u6309\u94ae\u7ec4";
            }
        }
        return type;
    }

    private String translateElementType(String type) {
        switch (type) {
            case "grid-buttons": {
                type = "\u5de5\u5177\u680f\u6309\u94ae";
                break;
            }
            case "column-buttons": {
                type = "\u8868\u683c\u5217\u6309\u94ae";
                break;
            }
            case "column": {
                type = "\u8868\u683c\u5217";
                break;
            }
            case "form-buttons": {
                type = "\u6309\u94ae";
                break;
            }
            case "form-field": {
                type = "\u5b57\u6bb5";
            }
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    private MenuItem createResourceItemElements(ResourceItem resourceItem, ResourceItemCount itemCount) {
        MenuItem resourceItemMenu;
        block19: {
            ArrayList<MenuItem> resourceItemChildren;
            Object[] elementList;
            block21: {
                block20: {
                    resourceItemMenu = null;
                    elementList = this.resourceItemElementCache.getValue(resourceItem.getResourceItemId().toString());
                    if (!ArrayUtils.isNotEmpty((Object[])elementList)) break block19;
                    resourceItemMenu = new MenuItem();
                    resourceItemMenu.setText(this.translateItemType(resourceItem.getItemType()) + "  [" + resourceItem.getItemName() + "]");
                    resourceItemChildren = new ArrayList<MenuItem>();
                    resourceItemMenu.setChildren(resourceItemChildren);
                    if (!"buttons".equalsIgnoreCase(resourceItem.getItemType())) break block20;
                    resourceItemMenu.setIcon("fa  fa-hand-o-down");
                    resourceItemMenu.setId(itemCount.getBtnGroupId());
                    itemCount.setBtnGroupId(itemCount.getBtnGroupId() - 10L);
                    for (Object button : elementList) {
                        resourceItemChildren.add(this.createResourceItemElement((ResourceItemElement)button));
                    }
                    break block19;
                }
                if (!"form".equalsIgnoreCase(resourceItem.getItemType())) break block21;
                resourceItemMenu.setIcon("fa fa-wpforms");
                resourceItemMenu.setId(itemCount.getFormId());
                itemCount.setFormId(itemCount.getFormId() - 10L);
                ArrayList<Object> btnList = new ArrayList<Object>();
                ArrayList<Object> fieldList = new ArrayList<Object>();
                for (Object object : elementList) {
                    if ("form-buttons".equalsIgnoreCase(((ResourceItemElement)object).getType())) {
                        btnList.add(object);
                        continue;
                    }
                    if (!"form-field".equalsIgnoreCase(((ResourceItemElement)object).getType())) continue;
                    fieldList.add(object);
                }
                if (CollectionUtils.isNotEmpty(btnList)) {
                    MenuItem btnItem = new MenuItem();
                    btnItem.setId(itemCount.getBtnId());
                    itemCount.setBtnId(itemCount.getBtnId() - 10L);
                    btnItem.setText(this.translateElementType("form-buttons"));
                    btnItem.setIcon("fa  fa-hand-o-down");
                    resourceItemChildren.add(btnItem);
                    ArrayList<MenuItem> btnChildren = new ArrayList<MenuItem>();
                    btnItem.setChildren(btnChildren);
                    for (ResourceItemElement resourceItemElement : btnList) {
                        btnChildren.add(this.createResourceItemElement(resourceItemElement));
                    }
                }
                if (!CollectionUtils.isNotEmpty(fieldList)) break block19;
                MenuItem fieldItem = new MenuItem();
                fieldItem.setId(itemCount.getFieldId());
                itemCount.setFieldId(itemCount.getFieldId() - 10L);
                fieldItem.setText(this.translateElementType("form-field"));
                fieldItem.setIcon("fa fa-file-text");
                resourceItemChildren.add(fieldItem);
                ArrayList<MenuItem> fieldChildren = new ArrayList<MenuItem>();
                fieldItem.setChildren(fieldChildren);
                for (ResourceItemElement resourceItemElement : fieldList) {
                    fieldChildren.add(this.createResourceItemElement(resourceItemElement));
                }
                break block19;
            }
            if ("grid".equalsIgnoreCase(resourceItem.getItemType())) {
                void var11_33;
                resourceItemMenu.setIcon("fa fa-table");
                resourceItemMenu.setId(itemCount.getGridId());
                itemCount.setGridId(itemCount.getGridId() - 10L);
                ArrayList<Object> toolbarList = new ArrayList<Object>();
                ArrayList<Object> colBtnList = new ArrayList<Object>();
                ArrayList<Object> colList = new ArrayList<Object>();
                Object[] fieldChildren = elementList;
                int n = fieldChildren.length;
                boolean bl = false;
                while (var11_33 < n) {
                    Object object = fieldChildren[var11_33];
                    if ("grid-buttons".equalsIgnoreCase(((ResourceItemElement)object).getType())) {
                        toolbarList.add(object);
                    } else if ("column-buttons".equalsIgnoreCase(((ResourceItemElement)object).getType())) {
                        colBtnList.add(object);
                    } else if ("column".equalsIgnoreCase(((ResourceItemElement)object).getType())) {
                        colList.add(object);
                    }
                    ++var11_33;
                }
                if (CollectionUtils.isNotEmpty(toolbarList)) {
                    MenuItem toolbarItem = new MenuItem();
                    toolbarItem.setId(itemCount.getToolbarId());
                    itemCount.setToolbarId(itemCount.getToolbarId() - 10L);
                    toolbarItem.setText(this.translateElementType("grid-buttons"));
                    toolbarItem.setIcon("fa fa-bars");
                    resourceItemChildren.add(toolbarItem);
                    ArrayList<MenuItem> toobarChildren = new ArrayList<MenuItem>();
                    toolbarItem.setChildren(toobarChildren);
                    for (ResourceItemElement resourceItemElement : toolbarList) {
                        toobarChildren.add(this.createResourceItemElement(resourceItemElement));
                    }
                }
                if (CollectionUtils.isNotEmpty(colBtnList)) {
                    MenuItem colBtnItem = new MenuItem();
                    colBtnItem.setId(itemCount.getColumnButtonId());
                    itemCount.setColumnButtonId(itemCount.getColumnButtonId() - 10L);
                    colBtnItem.setText(this.translateElementType("column-buttons"));
                    colBtnItem.setIcon("fa  fa-hand-o-down");
                    resourceItemChildren.add(colBtnItem);
                    ArrayList<MenuItem> colBtnChildren = new ArrayList<MenuItem>();
                    colBtnItem.setChildren(colBtnChildren);
                    for (ResourceItemElement resourceItemElement : colBtnList) {
                        colBtnChildren.add(this.createResourceItemElement(resourceItemElement));
                    }
                }
                if (CollectionUtils.isNotEmpty(colList)) {
                    MenuItem colItem = new MenuItem();
                    colItem.setId(itemCount.getColumnId());
                    itemCount.setColumnId(itemCount.getColumnId() - 10L);
                    colItem.setText(this.translateElementType("column"));
                    colItem.setIcon("fa fa-columns");
                    resourceItemChildren.add(colItem);
                    ArrayList<MenuItem> colChildren = new ArrayList<MenuItem>();
                    colItem.setChildren(colChildren);
                    for (ResourceItemElement resourceItemElement : colList) {
                        colChildren.add(this.createResourceItemElement(resourceItemElement));
                    }
                }
            }
        }
        return resourceItemMenu;
    }

    private MenuItem createResourceItemElement(ResourceItemElement resourceItemElement) {
        MenuItem menuItem = new MenuItem();
        menuItem.setText(resourceItemElement.getName());
        menuItem.setId(resourceItemElement.getElementId());
        menuItem.setIschecked(Boolean.TRUE);
        menuItem.setIcon("fa fa-pencil-square-o");
        menuItem.setFunctionCode("newData");
        return menuItem;
    }

    @Override
    public List<MenuItem> queryRoleResourceItems(IRequest requestContext, Long roleId, Long functionId) {
        Function function = new Function();
        function.setFunctionId(functionId);
        Long[] roleResourceItemIds = null;
        if (roleId != null) {
            roleResourceItemIds = this.roleResourceItemCache.getValue(roleId.toString());
        }
        return this.castResourceItemsToMenuItem(this.queryHtmlResources(requestContext, function), roleResourceItemIds);
    }

    private List<MenuItem> castResourceItemsToMenuItem(List<Resource> resourceList, Long[] roleResourceItemIds) {
        MenuItem root = new MenuItem();
        ArrayList<MenuItem> children = new ArrayList<MenuItem>();
        root.setChildren(children);
        if (resourceList != null) {
            for (Resource resource : resourceList) {
                MenuItem menuItem = this.createResourcesMenuItem(resource, roleResourceItemIds);
                if (menuItem == null) continue;
                children.add(menuItem);
            }
        }
        return root.getChildren();
    }

    private MenuItem createResourcesMenuItem(Resource resource, Long[] roleResourceItemIds) {
        Object[] resourceItems = this.resourceItemCache.getValue(resource.getResourceId().toString());
        int size = 0;
        if (ArrayUtils.isNotEmpty((Object[])resourceItems)) {
            MenuItem menu = new MenuItem();
            ArrayList<MenuItem> children = new ArrayList<MenuItem>();
            menu.setChildren(children);
            menu.setText(resource.getName());
            menu.setUrl(resource.getUrl());
            menu.setId(resource.getResourceId());
            for (Object resourceItem : resourceItems) {
                MenuItem menuItem = this.createResourceItemsMenuItem((ResourceItem)resourceItem);
                if (ArrayUtils.isNotEmpty((Object[])roleResourceItemIds)) {
                    for (Long roleResourceItemId : roleResourceItemIds) {
                        if (!roleResourceItemId.equals(((ResourceItem)resourceItem).getResourceItemId())) continue;
                        menuItem.setIschecked(Boolean.TRUE);
                        ++size;
                        break;
                    }
                }
                children.add(menuItem);
            }
            if (size == resourceItems.length) {
                menu.setIschecked(Boolean.TRUE);
            }
            return menu;
        }
        return null;
    }

    private MenuItem createResourceItemsMenuItem(ResourceItem resourceItem) {
        MenuItem menu = new MenuItem();
        menu.setText(resourceItem.getItemName());
        menu.setUrl(resourceItem.getDescription());
        menu.setId(resourceItem.getResourceItemId());
        return menu;
    }

    @Override
    public List<RoleResourceItem> batchUpdate(IRequest requestContext, List<RoleResourceItem> roleResourceItems, Long roleId, Long functionId) {
        this.roleResourceItemMapper.deleteByRoleIdAndFunctionId(roleId, functionId);
        if (CollectionUtils.isNotEmpty(roleResourceItems)) {
            for (RoleResourceItem roleResourceItem : roleResourceItems) {
                this.roleResourceItemMapper.insertSelective(roleResourceItem);
            }
        }
        this.roleResourceItemCache.load(roleId.toString());
        return roleResourceItems;
    }

    @Override
    public List<ResourceItemAssign> updateResourceItemAssign(IRequest requestContext, List<ResourceItemAssign> resourceItemAssignList, Long roleId, Long functionId) {
        this.roleResourceItemMapper.deleteByRoleIdAndFunctionId(roleId, functionId);
        this.resourceItemAssignMapper.deleteByRoleIdAndFunctionId(roleId, functionId);
        if (CollectionUtils.isNotEmpty(resourceItemAssignList)) {
            for (ResourceItemAssign resourceItemAssign : resourceItemAssignList) {
                if ("oldType".equalsIgnoreCase(resourceItemAssign.getAssignType())) {
                    RoleResourceItem roleResourceItem = new RoleResourceItem();
                    roleResourceItem.setRoleId(resourceItemAssign.getTypeId());
                    roleResourceItem.setResourceItemId(resourceItemAssign.getElementId());
                    this.roleResourceItemMapper.insertSelective(roleResourceItem);
                    continue;
                }
                if (!"newType".equalsIgnoreCase(resourceItemAssign.getAssignType())) continue;
                resourceItemAssign.setAssignType("role");
                resourceItemAssign.setEnable("N");
                resourceItemAssign.setFunctionId(functionId);
                this.resourceItemAssignMapper.insertSelective(resourceItemAssign);
            }
        }
        this.roleResourceItemCache.load(roleId.toString());
        this.resourceItemAssignCache.load("role_" + roleId);
        return resourceItemAssignList;
    }

    @Override
    public boolean hasResourceItem(Long roleId, Long resourceItemId) {
        if (roleId == null || resourceItemId == null) {
            return false;
        }
        return this.roleResourceItemMapper.selectByRoleIdAndResourceItemId(roleId, resourceItemId) != null;
    }
}

