/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.service.impl;

import com.hand.hap.cache.impl.RoleFunctionCache;
import com.hand.hap.cache.impl.RoleResourceCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.function.dto.RoleFunction;
import com.hand.hap.function.mapper.RoleFunctionMapper;
import com.hand.hap.function.service.IRoleFunctionService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class RoleFunctionServiceImpl
extends BaseServiceImpl<RoleFunction>
implements IRoleFunctionService {
    @Autowired
    private RoleFunctionMapper rolefunctionMapper;
    @Autowired
    private RoleFunctionCache roleFunctionCache;
    @Autowired
    private RoleResourceCache roleResourceCache;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public Long[] getRoleFunctionById(Long roleId) {
        Long[] roleFuction = this.roleFunctionCache.getValue(roleId.toString());
        if (roleFuction == null) {
            this.roleFunctionCache.reload();
            return this.roleFunctionCache.getValue(roleId.toString());
        }
        return roleFuction;
    }

    @Override
    public List<RoleFunction> batchUpdate(IRequest requestContext, List<RoleFunction> roleFunctions) {
        if (roleFunctions != null && !roleFunctions.isEmpty()) {
            RoleFunction rf = roleFunctions.get(0);
            Long[] ids = new Long[roleFunctions.size()];
            Long roleId = rf.getRoleId();
            int i = 0;
            this.rolefunctionMapper.deleteByRoleId(roleId);
            for (RoleFunction rolefunction : roleFunctions) {
                if (rolefunction.getFunctionId() != null) {
                    this.rolefunctionMapper.insertSelective(rolefunction);
                    ids[i++] = rolefunction.getFunctionId();
                    continue;
                }
                ids = new Long[]{};
            }
            this.clearRoleFunctionCacheByRoleId(roleId);
            this.roleFunctionCache.setValue(roleId.toString(), ids);
            ((IRoleFunctionService)this.self()).reloadRoleResourceCache(roleId);
        }
        return roleFunctions;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public void clearRoleFunctionByRoleId(Long roleId) {
        this.rolefunctionMapper.deleteByRoleId(roleId);
        this.clearRoleFunctionCacheByRoleId(roleId);
    }

    private void clearRoleFunctionCacheByRoleId(Long roleId) {
        this.roleFunctionCache.remove(roleId.toString());
        this.roleResourceCache.remove(roleId.toString());
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public void reloadRoleResourceCache(Long roleId) {
        this.roleResourceCache.remove(roleId.toString());
        this.roleResourceCache.loadRoleResource(roleId);
    }
}

