/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.service.impl;

import com.hand.hap.cache.impl.ResourceItemElementCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.function.dto.ResourceItemElement;
import com.hand.hap.function.mapper.ResourceItemAssignMapper;
import com.hand.hap.function.mapper.ResourceItemElementMapper;
import com.hand.hap.function.service.IResourceItemElementService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ResourceItemElementServiceImpl
extends BaseServiceImpl<ResourceItemElement>
implements IResourceItemElementService {
    @Autowired
    private ResourceItemElementMapper elementMapper;
    @Autowired
    private ResourceItemElementCache elementCache;
    @Autowired
    private ResourceItemAssignMapper itemAssignMapper;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ResourceItemElement insertSelective(IRequest request, ResourceItemElement element) {
        if (element == null) {
            return null;
        }
        super.insertSelective(request, element);
        this.elementCache.load(element.getResourceItemId());
        return element;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ResourceItemElement updateByPrimaryKey(IRequest request, ResourceItemElement element) {
        if (element == null) {
            return null;
        }
        super.updateByPrimaryKey(request, element);
        this.elementCache.load(element.getResourceItemId());
        return element;
    }

    @Override
    public List<ResourceItemElement> batchUpdate(IRequest request, List<ResourceItemElement> elementList) {
        if (CollectionUtils.isEmpty(elementList)) {
            return elementList;
        }
        for (ResourceItemElement element : elementList) {
            if (element.getElementId() == null) {
                ((IResourceItemElementService)this.self()).insertSelective(request, element);
                continue;
            }
            ((IResourceItemElementService)this.self()).updateByPrimaryKey(request, element);
        }
        return elementList;
    }

    @Override
    public void batchDelete(IRequest requestContext, List<ResourceItemElement> elementList) {
        if (CollectionUtils.isEmpty(elementList)) {
            return;
        }
        for (ResourceItemElement element : elementList) {
            int updateCount = this.elementMapper.deleteByPrimaryKey(element);
            this.checkOvn(updateCount, element);
            this.itemAssignMapper.deleteByElementId(element.getElementId());
        }
        this.elementCache.load(elementList.get(0).getResourceItemId());
    }

    @Override
    public List<ResourceItemElement> selectByResourceItemId(IRequest requestContext, ResourceItemElement element) {
        return this.elementMapper.selectByResourceItemId(element);
    }
}

